<?php

class Brivium_AttachmentEssential_ControllerPublic_Account extends XFCP_Brivium_AttachmentEssential_ControllerPublic_Account
{
	public function actionAttachments()
	{
		$options = XenForo_Application::get('options');

		$input = $this->_input->filter(array(
			'mode' => XenForo_Input::STRING,
			'content_type' => XenForo_Input::STRING,
			'end' => XenForo_Input::STRING,
			'start' => XenForo_Input::STRING,
			'overlay' => XenForo_Input::STRING
		));

		$dateInput = $this->_input->filter(array(
			'start' => XenForo_Input::DATE_TIME,
			'end' => XenForo_Input::DATE_TIME,
		));

		$attachmentEssentialModel = $this->_getAttachmentEssentialModel();
		$attachmentModel = $this->_getAttachmentModel('XenForo_Model_Attachment');
		$nodeModel = $this->_getNodeModel('XenForo_Model_Node');
		$postModel = $this->_getPostModel('XenForo_Model_Post');
		$conversationModel = $this->_getConversationModel('XenForo_Model_Conversation');
		
		if (!$attachmentEssentialModel->canViewMyAttachments()) 
		{
			return $this->responseNoPermission();
		}

		$page = max(1, $this->_input->filterSingle('page', XenForo_Input::UINT));
		if ($input['overlay'])
		{
			$perPage = 9999; /* Avoid pagination in overlay */
		}
		else
		{
			$perPage = $options->AttachmentEssential_perPage;
		}

		$orderParams = array();
		foreach (array('recent', 'size', 'views') as $field)
		{
			$orderParams[$field] = array();
			$orderParams[$field]['mode'] = ($field != 'recent' ? $field : false);
			if ($input['start']) 
			{
				$orderParams[$field]['start'] = $input['start'];
			}
			if ($input['end']) 
			{
				$orderParams[$field]['end'] = $input['end'];
			}
			if ($input['content_type']) 
			{
				$orderParams[$field]['content_type'] = $input['content_type'];
			}
			if ($input['overlay']) 
			{
				$orderParams[$field]['overlay'] = $input['overlay'];
			}
		}
		
		$filterParams = array();
		foreach (array ('mode', 'start', 'end', 'content_type', 'overlay') as $key)
		{
			if ($input[$key]) 
			{ 
				$filterParams[$key] = $input[$key]; 
			}
		}
		
		$direction = 'desc';

		$conditions = array(
			'user_id' => XenForo_Visitor::getUserId(),
			'content_type' => $input['content_type'],
			'start' => $dateInput['start'],
			'end' => $dateInput['end'],
		);
		
		$fetchOptions = array(
			'page' => $page,
			'perPage' => $perPage
		);
	
		switch ($input['mode'])
		{
			case 'size':
				$fetchOptions['order'] = 'size';
				break;
			
			case 'views':
				$fetchOptions['order'] = 'views';
				break;

			case 'recent';
			default:
				$input['mode'] = 'recent';
				$fetchOptions['order'] = 'recent';
				break;
		}

		$attachments = $attachmentModel->getAttachments($conditions, $fetchOptions);
		$attachments = $attachmentModel->prepareAttachments($attachments, true);
		$total = $attachmentModel->countAttachments($conditions, $fetchOptions);
		
		$postIds = array();
		$conversationIds = array();
		$conversationMessage = $options->AttachmentEssential_conversationMessage;
		$i = 1;

		foreach ($attachments as $attachment)
		{
			if (!empty($attachment['content_type']) && $attachment['content_type'] == 'post')
			{
				$postIds[] = $attachment['content_id'];
			}
			if (!empty($attachment['content_type']) && $attachment['content_type'] == 'conversation_message')
			{
				if ($conversationMessage)
				{
					$conversationIds[] = $attachment['content_id'];
					$conversationMessage ? $attachments[$i]['content_link'] = XenForo_Link::buildPublicLink('conversations/message', '', array('message_id' => $attachment['content_id'])) : '';
				}
				else
				{
					unset($attachments[$i]);
				}
			}
			$i++;
		}
		
		$posts = array();
		if (!empty($postIds))
		{
			$posts = $postModel->getPostsByIds($postIds);
			foreach ($attachments as &$attachment)
			{
				if (!empty($attachment['content_type']) && $attachment['content_type'] == 'post' && !empty($posts[$attachment['content_id']]))
				{
					$attachment['preparedPost'] = $posts[$attachment['content_id']];
				}
			}
		}

		if (!empty($conversationIds) && $conversationMessage)
		{
			foreach ($attachments as &$attachment)
			{
				if (!empty($attachment['content_type']) && $attachment['content_type'] == 'conversation_message')
				{
					$attachment['preparedPost'] = $conversationModel->getConversationMessageById($attachment['content_id']);
				}
			}
		}
		
		$viewParams = array(
			'attachments' => $attachments,
			'total' => $total,
		
			'page' => $page,
			'perPage' => $perPage,
			'filterParams' => $filterParams,
			'startOffset' => ($page - 1) * $perPage + 1,
			'endOffset' => ($page - 1) * $perPage + count($attachments),

			'contentTypes' => $attachmentModel->getAttachmentHandlerContentTypeNames(),
			
			'contentType' => $input['content_type'],			
			'start' => $input['start'],
			'end' => $input['end'],
			'overlay' => $input['overlay'],

			'datePresets' => XenForo_Helper_Date::getDatePresets(),
		
			'mode' => $input['mode'],
			'orderParams' => $orderParams,
			'direction' => $direction,

			'canDeleteMyAttachments' => $attachmentEssentialModel->canDeleteMyAttachments()
		);
	
		if ($input['overlay']) 
		{
			return $this->responseView('Brivium_AttachmentEssential_ViewPublic', 'AttachmentEssential_list_overlay', $viewParams);
		}
		else 
		{
			return $this->_getWrapper(
				'account',
				'attachments',
				$this->responseView('Brivium_AttachmentEssential_ViewPublic', 'AttachmentEssential_list', $viewParams)
			);
		}
	}

	protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}

	protected function _getAttachmentModel()
	{
		return $this->getModelFromCache('XenForo_Model_Attachment');
	}

	protected function _getNodeModel()
	{
		return $this->getModelFromCache('XenForo_Model_Node');
	}

	protected function _getPostModel()
	{
		return $this->getModelFromCache('XenForo_Model_Post');
	}

	protected function _getConversationModel()
	{
		return $this->getModelFromCache('XenForo_Model_Conversation');
	}
}