<?php

class Brivium_AttachmentEssential_ControllerPublic_Attachment extends XFCP_Brivium_AttachmentEssential_ControllerPublic_Attachment
{
	public function actionIndex()
	{
		//response = parent::actionIndex();
		if ($userId = XenForo_Visitor::getUserId()) 
		{
			$options = XenForo_Application::get('options');
			$visitor = XenForo_Visitor::getInstance()->toArray();

			$attachmentId = $this->_input->filterSingle('attachment_id', XenForo_Input::UINT);	       	    
	        $attachment = $this->_getAttachmentOrError($attachmentId);		
			$tempHash = $this->_input->filterSingle('temp_hash', XenForo_Input::STRING);
			$ftpHelper = $this->getHelper('ForumThreadPost');
			list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($attachment['content_id']);

			$userModel = $this->_getUserModel();
			$attachmentModel = $this->_getAttachmentModel();
	        $attachmentEssentialModel = $this->_getAttachmentEssentialModel();

			$extension = XenForo_Helper_File::getFileExtension($attachment['filename']);
			
			$excludedExtensions = preg_split('/\s+/', trim($options->AttachmentEssential_extensions));
			$excludedForums = $options->AttachmentEssential_forums;
			$userGroups = $options->AttachmentEssential_userGroups;

			$lastDownload = $attachmentEssentialModel->getLimitById($userId);

			$attachmentPermission = $attachmentEssentialModel->getAttachmentPermissions();

			$limitDownloadCount = $attachmentPermission['download'] ? $attachmentPermission['download'] - 1 : false;
			$limitDownloadTime = $attachmentPermission['time'] ? $attachmentPermission['time'] * 60 : false;
			$downloadTime = $lastDownload['download_date'] + $limitDownloadTime;

			$prefix = '';
			if ($options->AttachmentEssential_addPrefix['enabled'])
			{
				$prefix .= $options->AttachmentEssential_addPrefix['prefix'];
			}

			foreach ($userGroups as &$userGroupId)
			{
				if ($userModel->isMemberOfUserGroup($visitor, $userGroupId))
				{
					$prefix .= '['.$visitor['username'].']';
					break;
				}
			}

			if (!in_array($extension, $excludedExtensions) && !in_array($forum['node_id'], $excludedForums))
			{
				if ($attachmentModel->canViewAttachment($attachment, $tempHash))
				{
					if ($options->AttachmentEssential_track)
					{
						if (!$attachmentEssentialModel->isDownloaded($attachment, $userId)) 
						{
							$attachmentEssentialModel->logAttachmentTracker($attachment, $userId);
						}
						else
						{
							$attachmentEssentialModel->updateAttachmentTracker($attachment, $userId);
						}

					}
					if ($limitDownloadTime && $limitDownloadCount)
					{
						if ($downloadTime <= XenForo_Application::$time) 
						{
							if (!$attachmentEssentialModel->getLimitById($userId)) 
							{
								$attachmentEssentialModel->logDownloadLimit($userId);
							}
							else
							{
								$attachmentEssentialModel->updateDownloadLimit($userId, XenForo_Application::$time);
							}
			       	 	}
			       	 	else 
			       	 	{
			       	 		if ($lastDownload['download_limit'] <= $limitDownloadCount)
			       	 		{
								$attachmentEssentialModel->updateDownloadLimit($userId);
			       	 		}
			       	 		else 
			       	 		{			       	
			       	 			return $this->responseError(new XenForo_Phrase('you_have_reached_your_download_limit'));
			       	 		}
			       	 	}
					}
				}
			}
			$response = parent::actionIndex();
			if(!empty($response->params['attachment']['filename'])){
				$response->params['attachment']['filename'] = $prefix.$response->params['attachment']['filename'];
			}
			return $response;
        }else{
			return parent::actionIndex();
		}
        
    }

    public function actionTracker()
	{
		if (XenForo_Application::get('options')->AttachmentEssential_track)
		{
			$attachmentId = $this->_input->filterSingle('attachment_id', XenForo_Input::UINT);
	        $attachment = $this->_getAttachmentOrError($attachmentId);
	        
	        $attachmentEssentialModel = $this->_getAttachmentEssentialModel();
			                
			$downloads = $attachmentEssentialModel->getDownloads(array('attachment_id' => $attachmentId), array(
				'join' => Brivium_AttachmentEssential_Model_AttachmentEssential::FETCH_USER,
				'fetch' => 'allKeyed'
			));

	        if (!$attachmentEssentialModel->canViewDownloadTracker())
			{
				return $this->responseNoPermission();
			}
			
			if (!$downloads)
			{
				return $this->responseError(new XenForo_Phrase('download_tracker_is_not_available'));
			}
			
			$viewParams = array(
				'attachment' => $attachment,		
				'downloads' => $downloads
			);

			return $this->responseView('Brivium_AttachmentEssential_ViewPublic', 'AttachmentEssential_download_tracker', $viewParams);
		}
		else
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('requested_page_not_found'), 404));
		}
	}

	public function actionDelete()
	{	
		if ($this->_input->filterSingle('AttachmentEssential', XenForo_Input::UINT)) 
		{
			$this->_assertRegistrationRequired();
			$this->_assertPostOnly();
			
			$attachmentEssentialModel = $this->_getAttachmentEssentialModel();

			if (!$attachmentEssentialModel->canDeleteMyAttachments()) 
			{
				return $this->responseNoPermission();
			}

			$input = $this->_input->filter(array(
				'attachment_id' => XenForo_Input::UINT,
				'hash' => XenForo_Input::STRING,
				'contentType' => XenForo_Input::STRING,
				'content_data' => array(XenForo_Input::UINT, 'array' => true)
			));

			$filterParams = $this->_input->filter(array(
				'mode' => XenForo_Input::STRING,
				'content_type' => XenForo_Input::STRING,
				'end' => XenForo_Input::STRING,
				'start' => XenForo_Input::STRING,
				'overlay' => XenForo_Input::STRING
			));
		
			if (!$input['hash'])
			{
				$input['hash'] = $this->_input->filterSingle('attachment_hash', XenForo_Input::STRING);
			}

			$arr1 = $this->_getAttachmentOrError($input['attachment_id']);
			$arr2 = $this->_getAttachmentModel()->getAttachmentDataById($arr1['data_id']);
			$attachment = array_merge($arr1, $arr2);
		
			if (XenForo_Visitor::getUserId() != $attachment['user_id']) 
			{
				return $this->responseNoPermission();
			}
			
			if ($this->isConfirmedPost())
			{
				$dw = XenForo_DataWriter::create('XenForo_DataWriter_Attachment');
				$dw->setExistingData($attachment, true);
				$dw->delete();
		
				return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_Link::buildPublicLink('account/attachments', '', $filterParams)
				);
			}
			else 
			{	
				$viewParams = array(
					'attachment_id' => $input['attachment_id'],
					'contentType' => $input['contentType'],
					'filterParams' => $filterParams,
					'attachment' => $attachment
				);

				return $this->responseView('Brivium_AttachmentEssential_ViewPublic', 'AttachmentEssential_delete', $viewParams);		
			}
		}
		else
		{
			return parent::actionDelete();
		}
	}

	/*
	protected function _getAttachmentOrError($attachmentId) 
	{
		static $cached = array();
		
		if (empty($cached[$attachmentId])) 
		{
			$cached[$attachmentId] = parent::_getAttachmentOrError($attachmentId);
		}
		
		return $cached[$attachmentId];
	}
	*/

	protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}

	protected function _getAttachmentModel()
	{
		return $this->getModelFromCache('XenForo_Model_Attachment');
	}

	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
}