<?php

/**
 * Controller for handling actions on forums.
 *
 * @package XenForo_Forum
 */
class Brivium_AttachmentEssential_ControllerPublic_Forum extends XFCP_Brivium_AttachmentEssential_ControllerPublic_Forum
{
	public function actionIndex()
	{
		$response = parent::actionIndex();
		if ($response instanceof XenForo_ControllerResponse_View)
		{
			$response->params += array(
				'attachmentTotals' => $this->_getAttachmentTotals()
			);
		}
		return $response;
	}

	protected function _getAttachmentTotals()
	{
		$attachmentTotals = $this->getModelFromCache('XenForo_Model_DataRegistry')->get('attachmentTotals');
		if (!$attachmentTotals)
		{
			$attachmentTotals = $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential')->rebuildAttachmentTotalsCounter();
		}

		return $attachmentTotals;
	}
}