<?php

class Brivium_AttachmentEssential_ControllerPublic_Member extends XFCP_Brivium_AttachmentEssential_ControllerPublic_Member
{
	
	public function actionDownload()
    {
        $userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		$user = $this->getHelper('UserProfile')->assertUserProfileValidAndViewable($userId);
		$attachmentEssentialModel = $this->_getAttachmentEssentialModel();

		$visitor = XenForo_Visitor::getUserId();

		if ($userId != $visitor && !$attachmentEssentialModel->canViewDownloadTracker())
		{
			return $this->responseNoPermission();
		}
		
		$downloads = $attachmentEssentialModel->getDownloads(array('user_id' => $userId), array(
			'join' => Brivium_AttachmentEssential_Model_AttachmentEssential::FETCH_USER,
			'fetch' => 'allKeyed'
		));
		
		$viewParams = array(
			'user' => $user,
			'downloads' => $attachmentEssentialModel->prepareDownloads($downloads)
		);

        return $this->responseView('Brivium_AttachmentEssential_ViewPublic', 'AttachmentEssential_profile_tab_content', $viewParams);
    }
    
    protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}
}
