<?php

class Brivium_AttachmentEssential_ControllerPublic_Resource extends XFCP_Brivium_AttachmentEssential_ControllerPublic_Resource
{
	public function actionTracker()
	{
		if (XenForo_Application::get('options')->AttachmentEssential_track)
		{
			$versionModel = $this->_getVersionModel();
			$attachmentEssentialModel = $this->_getAttachmentEssentialModel();

			$versionId = $this->_input->filterSingle('version', XenForo_Input::UINT);
			$version = $versionModel->getVersionById($versionId, array(
				'join' => XenResource_Model_Version::FETCH_FILE
			));

			$downloads = $attachmentEssentialModel->getDownloads(array('attachment_id' => $version['attachment_id']), array(
				'join' => Brivium_AttachmentEssential_Model_AttachmentEssential::FETCH_USER,
				'fetch' => 'allKeyed'
			));
			
			if (!$downloads)
			{
				return $this->responseError(new XenForo_Phrase('download_tracker_is_not_available'));
			}
			
			$version['filename'] = $version['attachment_filename'];

			$viewParams = array(
				'attachment' => $version,		
				'downloads' => $downloads
			);

			return $this->responseView('Brivium_AttachmentEssential_ViewPublic', 'AttachmentEssential_download_tracker', $viewParams);
		}
		else
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('requested_page_not_found'), 404));
		}
	}

	protected function _getVersionModel()
	{
		return $this->getModelFromCache('XenResource_Model_Version');
	}

	protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}
}