<?php

class Brivium_AttachmentEssential_DataWriter_Attachment extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'xf_attachment_essential' => array(
				'download_id' 		=> array('type' => self::TYPE_UINT,   'autoIncrement' => true),
				'user_id'			=> array('type' => self::TYPE_UINT,   'required' => true),
				'attachment_id'		=> array('type' => self::TYPE_UINT,   'required' => true),
				'download_date'		=> array('type' => self::TYPE_UINT,   'default' => XenForo_Application::$time),
				'download_count'	=> array('type' => self::TYPE_UINT,   'required' => true, 'default' => 1),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('xf_attachment_essential' => $this->_getAttachmentEssentialModel()->getDownloadById($id));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'download_id = ' . $this->_db->quote($this->getExisting('download_id'));
	}

	protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}
}