<?php

class Brivium_AttachmentEssential_DataWriter_Limit extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'xf_attachment_essential_limit' => array(
				'user_id'			=> array('type' => self::TYPE_UINT,   'required' => true),
				'download_date'		=> array('type' => self::TYPE_UINT,   'default' => XenForo_Application::$time),
				'download_limit'	=> array('type' => self::TYPE_UINT,   'required' => true, 'default' => 1),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('xf_attachment_essential_limit' => $this->_getAttachmentEssentialModel()->getLimitById($id));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'user_id = ' . $this->_db->quote($this->getExisting('user_id'));
	}
	
	protected function _getAttachmentEssentialModel()
	{
		return $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential');
	}
}