<?php

class Brivium_AttachmentEssential_Install
{
	public static function dbColumn($table, $field, $action = 'drop', $attr = NULL, $after = NULL)
	{
		$exists = self::checkIfFieldExist($table, $field);
		$db = XenForo_Application::get('db');

		$action = strtolower($action);

		if ($action == 'drop') 
		{
			if ($exists)
			{
				return $db->query("ALTER TABLE `" . $table . "` DROP `" . $field);  
			}
		}
		elseif ($action == 'add')
		{
			if (!$exists)
			{
				$afterColumn = !empty($after) ? " AFTER " . $after : '';
				return $db->query("ALTER TABLE `" . $table . "` ADD `" . $field . "` " . $attr . $afterColumn);
			}            
		}
	}

	public static function checkIfFieldExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		return $db->fetchRow('SHOW COLUMNS FROM `' . $table . '` WHERE Field = ?', $field);
	}
	
	public static function checkIfTableExist($table)
	{
		$db = XenForo_Application::get('db');
		return $db->fetchRow('SHOW TABLES LIKE \'' . $table . '\''); 
	}
	
	public static function install()
	{
		$db = XenForo_Application::get('db');
		
		$db->query('
			CREATE TABLE IF NOT EXISTS xf_attachment_essential (
				download_id INT(10) UNSIGNED NOT NULL AUTO_INCREMENT ,
				user_id INT(10) UNSIGNED NOT NULL,
				attachment_id INT(10) UNSIGNED NOT NULL,
				download_date INT(10) UNSIGNED NOT NULL,
				download_count INT(10) UNSIGNED NOT NULL,
				PRIMARY KEY (download_id),
				KEY date (download_date)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		');

		$db->query('
			CREATE TABLE IF NOT EXISTS xf_attachment_essential_limit (
				user_id INT(10) UNSIGNED NOT NULL,
				download_date INT(10) UNSIGNED NOT NULL,
				download_limit INT(10) UNSIGNED NOT NULL,
				PRIMARY KEY (user_id)
			) ENGINE = InnoDB CHARACTER SET utf8 COLLATE utf8_general_ci
		');
	}
	
	public static function uninstall()
	{
		$db = XenForo_Application::get('db');

		$db->query("DROP TABLE `xf_attachment_essential`");
		
		$db->query("DROP TABLE `xf_attachment_essential_limit`");
	}
	
}