<?php
class Brivium_AttachmentEssential_Listener
{	
    public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template) 
    {        
        switch ($templateName)
        {
            case 'member_view':
                $template->preloadTemplate('AttachmentEssential_profile_tab');
                $template->preloadTemplate('AttachmentEssential_profile_tab_content');
                break;
            case 'PAGE_CONTAINER':
                $template->preloadTemplate('AttachmentEssential_navigation_visitor_tab');
                $template->preloadTemplate('AttachmentEssential_sidebar');
                break;
            case 'account_wrapper':
                $template->preloadTemplate('AttachmentEssential_account_wrapper');
                break;
            case 'resource_view':
                 $template->preloadTemplate('AttachmentEssential_resource_tools');
                break;
        }
    }

	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template) 
    {
		switch ($hookName)
        {
            case 'member_view_tabs_heading':
                $params = $template->getParams();
                $ourTemplate = $template->create('AttachmentEssential_profile_tab', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
            case 'member_view_tabs_content':
                $ourTemplate = $template->create('AttachmentEssential_profile_tab_content', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
            case 'navigation_visitor_tab_links2':
                $ourTemplate = $template->create('AttachmentEssential_navigation_visitor_tab', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
            case 'account_wrapper_sidebar_your_account':
                $ourTemplate = $template->create('AttachmentEssential_account_wrapper', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
            case 'forum_list_sidebar':
                $ourTemplate = $template->create('AttachmentEssential_sidebar', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
            case 'resource_controls':
                $ourTemplate = $template->create('AttachmentEssential_resource_tools', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
        }
	}

    public static function loadClassListener($class, &$extend)
    {
        if (class_exists('XenResource_ControllerPublic_Resource'))
        {
            if ($class == 'XenResource_ControllerPublic_Resource')
            {
                $extend[] = 'Brivium_AttachmentEssential_ControllerPublic_Resource';
            }
        }

        $classes = array(
            'Model_Attachment',

            'ControllerPublic_Index',
            'ControllerPublic_Forum',
            'ControllerPublic_Member',
            'ControllerPublic_Attachment',
            'ControllerPublic_Account',

            'ControllerAdmin_Attachment'
        );

        foreach($classes AS $_class)
        {
            if ($class == 'XenForo_' .$_class)
            {
                $extend[] = 'Brivium_AttachmentEssential_' .$_class;
            }
        }
    }

    public static function widgetFrameworkReady(array &$renderers) 
    {
        $renderers[] = 'Brivium_AttachmentEssential_WidgetRenderer_Attachment';
    }
}