<?php

class Brivium_AttachmentEssential_Model_Attachment extends XFCP_Brivium_AttachmentEssential_Model_Attachment
{	
	const FETCH_DOWNLOAD = 0x02;

	public function prepareAttachmentFetchOptions(array $fetchOptions)
	{
		$result = parent::prepareAttachmentFetchOptions($fetchOptions);
		
		$selectFields = '';
		$joinTables = '';

		if (isset($fetchOptions['join']))
		{
			if ($fetchOptions['join'] & self::FETCH_DOWNLOAD)
			{
				$selectFields .= ',
					download.*,
					user.*';
				$joinTables .= '
					INNER JOIN xf_attachment_essential AS download ON
						(download.attachment_id = attachment.attachment_id)
					LEFT JOIN xf_user AS user ON
						(user.user_id = download.user_id)';

				$result['selectFields'] = $selectFields;
				$result['joinTables'] = $joinTables;
			}
		}

		if (isset($fetchOptions['order']))
		{
			if ($fetchOptions['order'] == 'views')
			{
				$orderBy = 'attachment.view_count DESC';
				$result['orderClause'] = "ORDER BY $orderBy";
			}

			if ($fetchOptions['order'] == 'download')
			{
				$orderBy = 'download.download_date DESC';
				$result['orderClause'] = "ORDER BY $orderBy";
			}
		}

		return $result;
	}

	public function getAttachmentConstraints()
	{
		$params = parent::getAttachmentConstraints();

		$permission = $this->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential')->getAttachmentPermissions();

		$params['size'] = $permission['maxFileSize'];
		$params['width'] = $permission['maxWidth'];
		$params['height'] = $permission['maxHeight'];

		return $params;
	}
}