<?php

abstract class Brivium_AttachmentEssential_Option_UserGroupChooser
{
	public static function renderCheckbox(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		return self::_render('option_list_option_checkbox', $view, $fieldPrefix, $preparedOption, $canEdit);
	}

	public static function getUserGroupOptions($selectedGroup, $unspecifiedPhrase = false)
	{
		$userGroupModel = XenForo_Model::create('XenForo_Model_UserGroup');

		$options = $userGroupModel->getUserGroupOptions($selectedGroup);

		if ($unspecifiedPhrase)
		{
			$options = array_merge(array(array
			(
				'label' => $unspecifiedPhrase,
				'value' => 0,
				'selected' => ($selectedGroup == 0)
			)), $options);
		}

		return $options;
	}

	protected static function _render($templateName, XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
	{
		$preparedOption['formatParams'] = self::getUserGroupOptions(
			$preparedOption['option_value']
		);

		return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
			$templateName, $view, $fieldPrefix, $preparedOption, $canEdit
		);
	}
}