<?php

class Brivium_AttachmentEssential_WidgetRenderer_Attachment extends WidgetFramework_WidgetRenderer 
{
	protected function _getConfiguration() 
	{
		return array(
			'name' => 'Attachment Statistics'
		);
	}
	
	protected function _getOptionsTemplate() 
	{
		return false;
	}
	
	protected function _getRenderTemplate(array $widget, $positionCode, array $params) 
	{
		return 'wf_widget_AttachmentEssential';
	}
	
	protected function _render(array $widget, $positionCode, array $params, XenForo_Template_Abstract $renderTemplateObject) 
	{
		if ('forum_list' == $positionCode && !empty($params['attachmentTotals'])) 
		{
			$renderTemplateObject->setParam('attachmentTotals', $params['attachmentTotals']);
		} 
		else 
		{
			$core = WidgetFramework_Core::getInstance();
			$attachmentTotals = $core->getModelFromCache('XenForo_Model_DataRegistry')->get('attachmentTotals');
			if (!$attachmentTotals) 
			{
				$attachmentTotals = $core->getModelFromCache('Brivium_AttachmentEssential_Model_AttachmentEssential')->rebuildAttachmentTotalsCounter();
			}
			
			$renderTemplateObject->setParam('attachmentTotals', $attachmentTotals);
		}
		
		return $renderTemplateObject->render();		
	}
}