<?php

class Brivium_CensorshipInConversation_Model_Conversation extends XFCP_Brivium_CensorshipInConversation_Model_Conversation
{

	public function prepareConversation(array $conversation) {
		// if option don't choose any user group or don't have censorWords
		if (empty ( $GLOBALS['brCensorWords'] )) {
			return parent::prepareConversation ( $conversation );
		}
		
		$censorWords = $GLOBALS['brCensorWords'];
		$userGroup = XenForo_Application::getOptions()->BRCIC_userGroup;
		if (! empty ( $conversation['user_id'] )) {
			$UserGroupReplace = Brivium_CensorshipInConversation_Helper_UserGroup::brGetUserGroupNotIN ( $userGroup );
			
			if(empty($conversation['user_group_id'])){
				$user = $this->getModelFromCache ( 'XenForo_Model_User' )->getUserById ( $conversation['user_id'] );
			}else{
				$user = $conversation;
			}
			
			$userGroupInConvesation = Brivium_CensorshipInConversation_Helper_UserGroup::brGetUserGroup ( $user );
			// get userGroup don't have in $UserGroupReplace
			$arrDiff = array_diff ( $userGroupInConvesation, $UserGroupReplace );

			if (empty ( $arrDiff )) {
				$censorCache = array();
				foreach ( $censorWords as $value ) {
					$censorCache[$value['regex']] = $value['replace'];
				}
				$conversation['title'] = preg_replace ( array_keys ( $censorCache ), $censorCache, $conversation['title'] );
			}
		}
		return parent::prepareConversation ( $conversation );
	}
}