<?php

class Brivium_Credits_ControllerPublic_Account extends XFCP_Brivium_Credits_ControllerPublic_Account
{
	
	## ------------------------------------------
	##
	## Alert preferences
	##

	public function actionAlertPreferences()
	{
		
		$response =  parent::actionAlertPreferences();
		if (!$this->_getCreditModel()->canUseCredits($error))
		{
			if(isset($response->subView->params)){
				//$actions = XenForo_Application::get('brcEvents')->getActions();
				$actionModel = $this->_getActionModel();
				$actions = $actionModel->getAllActions();
				$actions = $actionModel->prepareActions($actions);
				$alertActions = array();
				
				foreach($actions AS $action){
					$action['checked'] = true;
					if(isset($response->subView->params['alertOptOuts']['credits_'.$action['action_id']])){
						$action['checked'] = false;
					}
					$alertActions['credits_'.$action['action_id']] = $action;
				}
				$response->subView->params['actions'] = $alertActions;
			}
		}
		return $response;
	}
	
	## ------------------------------------------
	##
	## Personal Details
	##

	/**
	 * Save profile data
	 *
	 * @return XenForo_ControllerResponse_Redirect
	 */
	public function actionPersonalDetailsSave()
	{
		$GLOBALS['BRC_CPA_actionPersonalDetailsSave'] = $this;
		return parent::actionPersonalDetailsSave();
	}

	public function actionAvatarUpload()
	{
		$GLOBALS['BRC_CPA_actionPersonalDetailsSave'] = $this;
		return parent::actionAvatarUpload();
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
}