<?php

/**
 * Cron entry for updating credits interest.
 */
class Brivium_Credits_CronEntry_DailyReward
{
	public static function runDailyReward()
	{
		$creditModel = XenForo_Model::create('Brivium_Credits_Model_Credit');
		if(!$events = XenForo_Application::get('brcEvents')->dailyReward) return false;
		/* @var $userModel XenForo_Model_User */
		$userModel = XenForo_Model::create('XenForo_Model_User');
		$criteria = array(
			'user_state' => 'valid',
			'is_banned' => 0,
		);
		$users = $userModel->getUsers($criteria, array(
			'join' => XenForo_Model_User::FETCH_USER_FULL
		));
		$creditModel->setIsBulk(true);
		$creditModel->setIsWaitSubmit(true);
		$userIds = array();
		foreach ($users AS $user)
		{
			if($creditModel->updateUserCredit('dailyReward',$user['user_id'],array('user'=>$user))){
				$userIds[$user['user_id']] = $user['user_id'];
			}
		}
		$creditModel->commitUpdate(false);
		if($userIds)
			$creditModel->updateDailyRewardAmount($userIds);
	}
}