<?php

/**
* Data writer for conversation masters.
*
* @package XenForo_Conversation
*/

class Brivium_Credits_DataWriter_ConversationMaster extends XFCP_Brivium_Credits_DataWriter_ConversationMaster
{
	
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		$dataCredit = array(
			'content_id' 	=>	$this->get('conversation_id'),
			'content_type'	=>	'conversation',
		);
		if ($recipients = $this->_getUserModel()->getUsersByIds($this->_newRecipients, array('join' => XenForo_Model_User::FETCH_USER_FULL)))
		{
			$creditModel = XenForo_Model::create('Brivium_Credits_Model_Credit');
			$creditModel->setIsBulk(true);
			$creditModel->setIsWaitSubmit(true);
			
			foreach ($recipients AS $recipient)
			{
				$dataCredit['user'] = array();
				$dataCredit['user'] = $recipient;
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('receiveConversation',$recipient['user_id'],$dataCredit);
			}
			$creditModel->commitUpdate();
		}
		if (isset($GLOBALS['BRC_DW_replyConversation'])) {
			
			if($GLOBALS['BRC_DW_replyConversation']!=$this->get('user_id')){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('replyConversation',$GLOBALS['BRC_DW_replyConversation'],$dataCredit);
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('conversationGetReply',$this->get('user_id'),$dataCredit);
			}
			unset($GLOBALS['BRC_DW_replyConversation']);
		}
		return parent::_postSave();
	}

}