<?php
if (XenForo_Application::$versionId < 1020000)
{
class Brivium_Credits_DataWriter_Discussion_Thread extends XFCP_Brivium_Credits_DataWriter_Discussion_Thread
{
	protected function _saveFirstMessageDw()
	{
		$response = parent::_saveFirstMessageDw();
		$threadId = $this->get('thread_id');
		if ($this->isInsert())
		{
			$creditModel = $this->_getCreditModel();
			// createNewThread
			$messageDw = $this->_firstMessageDw;
			$wordCount = $creditModel->calculateWordAmount(strtolower($messageDw->get('message')));
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'multiplier' 	=> 	$wordCount,
				'content_id' 	=>	$this->get('thread_id'),
				'content_type'	=>	'thread',
				'errorMinimumHandle'	=>	new XenForo_Phrase('BRC_post_needs_to_have_at_least_x_words'),
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('createNewThread',$this->get('user_id'),$dataCredit);
		}
		return $response;
	}
	protected function _discussionPostDelete(array $messages)
	{
		$creditModel = $this->_getCreditModel();
		// threadDeleted
		$wordCount = 0;
		if(isset($GLOBALS['BRC_DELETETHREAD_WORDCOUNT'])){
			$wordCount = $GLOBALS['BRC_DELETETHREAD_WORDCOUNT'] ;
		}
		$dataCredit = array(
			'node_id'			=>	$this->get('node_id'),
			'multiplier'		=>	$wordCount,
			'ignore_min_handle'	=>	true,
			'content_id' 		=>	$this->get('thread_id'),
			'content_type'		=>	'thread',
			'extraData' 		=>	array('node_id'=>$this->get('node_id'))
		);
		$creditModel->updateUserCredit('threadDeleted',$this->get('user_id'),$dataCredit);
		return parent::_discussionPostDelete($messages);
	}
	protected function _deleteDiscussionMessages(array $messages)
	{
		$creditModel = $this->_getCreditModel();
		$firstPost = $this->getModelFromCache('XenForo_Model_Post')->getPostById($this->get('first_post_id'));
		$wordCount = $creditModel->calculateWordAmount(strtolower($firstPost['message']));
		$GLOBALS['BRC_DELETETHREAD_WORDCOUNT'] = $wordCount;
		return parent::_deleteDiscussionMessages($messages);
	}
	
	protected function _discussionPostSave(array $messages)
	{
		$creditModel = $this->_getCreditModel();
		// threadSticky
		if(($this->isInsert()  || ($this->isUpdate() && $this->isChanged('sticky'))) && $this->get('sticky')){
			
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'content_id' 	=>	$this->get('thread_id'),
				'content_type'	=>	'thread',
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
		}else if ($this->isUpdate() && $this->isChanged('sticky') && !$this->get('sticky')){
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'content_id' 	=>	$this->get('thread_id'),
				'content_type'	=>	'thread',
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$dataCredit['reverted'] = true;
			$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
		}
		return parent::_discussionPostSave($messages);
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
}
}else{

class Brivium_Credits_DataWriter_Discussion_Thread extends XFCP_Brivium_Credits_DataWriter_Discussion_Thread
{
	protected function _saveFirstMessageDw()
	{
		$response = parent::_saveFirstMessageDw();
		$threadId = $this->get('thread_id');
		if ($this->isInsert())
		{
			$creditModel = $this->_getCreditModel();
			// createNewThread
			$messageDw = $this->_firstMessageDw;
			$wordCount = $creditModel->calculateWordAmount(strtolower($messageDw->get('message')));
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'multiplier' 	=> 	$wordCount,
				'content_id' 	=>	$this->get('thread_id'),
				'content_type'	=>	'thread',
				'errorMinimumHandle'	=>	new XenForo_Phrase('BRC_post_needs_to_have_at_least_x_words'),
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('createNewThread',$this->get('user_id'),$dataCredit);
		}
		return $response;
	}
	protected function _discussionPostDelete()
	{
		$creditModel = $this->_getCreditModel();
		// threadDeleted
		$wordCount = 0;
		if(isset($GLOBALS['BRC_DELETETHREAD_WORDCOUNT'])){
			$wordCount = $GLOBALS['BRC_DELETETHREAD_WORDCOUNT'] ;
		}
		$dataCredit = array(
			'node_id'			=>	$this->get('node_id'),
			'multiplier'		=>	$wordCount,
			'ignore_min_handle'	=>	true,
			'content_id' 		=>	$this->get('thread_id'),
			'content_type'		=>	'thread',
			'extraData' 		=>	array('node_id'=>$this->get('node_id'))
		);
		$creditModel->updateUserCredit('threadDeleted',$this->get('user_id'),$dataCredit);
		return parent::_discussionPostDelete();
	}
	protected function _deleteDiscussionMessages()
	{
		$creditModel = $this->_getCreditModel();
		$firstPost = $this->getModelFromCache('XenForo_Model_Post')->getPostById($this->get('first_post_id'));
		$wordCount = $creditModel->calculateWordAmount(strtolower($firstPost['message']));
		$GLOBALS['BRC_DELETETHREAD_WORDCOUNT'] = $wordCount;
		return parent::_deleteDiscussionMessages();
	}
	
	protected function _discussionPostSave()
	{
		$creditModel = $this->_getCreditModel();
		// threadSticky
		if(($this->isInsert()  || ($this->isUpdate() && $this->isChanged('sticky'))) && $this->get('sticky')){
			
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'content_id' 	=>	$this->get('thread_id'),
				'content_type'	=>	'thread',
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
		}else if ($this->isUpdate() && $this->isChanged('sticky') && !$this->get('sticky')){
			$dataCredit = array(
				'node_id'		=>	$this->get('node_id'),
				'content_id' 	=>	$this->get('thread_id'),
				'content_type'	=>	'thread',
				'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
			);
			$dataCredit['reverted'] = true;
			$creditModel->updateUserCredit('threadSticky',$this->get('user_id'),$dataCredit);
		}
		return parent::_discussionPostSave();
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
}
}