<?php
class Brivium_Credits_DataWriter_Follower extends XFCP_Brivium_Credits_DataWriter_Follower
{
	/**
	* Post-save handler.
	*/
	protected function _postSave()
	{
		$creditModel = $this->_getCreditModel();
		$errorString = '';
		
		$creditModel->setIsWaitSubmit(true);
		$dataCredit = array(
			'user_action_id' 	=>	$this->get('follow_user_id'),
		);
		$creditModel->updateUserCredit('follow',$this->get('user_id'),$dataCredit,$errorString);
		$dataCredit = array(
			'user_action_id' 	=>	$this->get('user_id'),
		);
		$creditModel->updateUserCredit('getFollower',$this->get('follow_user_id'),$dataCredit);
		$creditModel->commitUpdate();
		
		
		return parent::_postSave();
	}

	/**
	 * Post-delete handler
	 */
	protected function _postDelete()
	{
		$creditModel = $this->_getCreditModel();
		$dataCredit = array(
			'reverted' 	=>	true,
		);
		
		$creditModel->setIsWaitSubmit(true);
		$dataCredit['user_action_id'] = $this->get('follow_user_id');
		$creditModel->updateUserCredit('follow',$this->get('user_id'),$dataCredit);
		
		$dataCredit['user_action_id'] = $this->get('user_id');
		$creditModel->updateUserCredit('getFollower',$this->get('follow_user_id'),$dataCredit);
		
		$creditModel->commitUpdate();
		return parent::_postDelete();
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
}