<?php
class Brivium_Credits_DataWriter_Poll extends XFCP_Brivium_Credits_DataWriter_Poll
{
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		if($this->get('content_type') == 'thread'){
			$creditModel = $this->_getCreditModel();
			if ($this->isInsert()){
				$thread = $this->getModelFromCache('XenForo_Model_Thread')->getThreadById($this->get('content_id'));
				$dataCredit = array(
					'node_id' 	=>	$thread['node_id'],
					'extraData' =>	array('thread_id'=>$this->get('thread_id'))
				);
				$creditModel->updateUserCredit('createNewPoll',$thread['user_id'],$dataCredit);
			}
			if($this->isUpdate() && $this->getExisting('voter_count') < $this->get('voter_count')){
				$thread = $this->getModelFromCache('XenForo_Model_Thread')->getThreadById($this->get('content_id'));
				if($thread['user_id'] != XenForo_Visitor::getUserId()){
					if(!empty($thread['user_id'])){
						$dataCredit = array(
							'node_id' 			=>	$thread['node_id'],
							'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
						);
						$creditModel->updateUserCredit('votePoll',XenForo_Visitor::getUserId(),$dataCredit);
						$dataCredit = array(
							'user_action_id' 	=>	XenForo_Visitor::getUserId(),
							'node_id' 			=>	$thread['node_id'],
							'extraData' 	=>	array('thread_id'=>$this->get('thread_id'))
						);
						$creditModel->updateUserCredit('pollGetVote',$thread['user_id'],$dataCredit);
					}
				}
			}
		}
		
		return parent::_postSave();
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}

}