<?php
class Brivium_Credits_DataWriter_User extends XFCP_Brivium_Credits_DataWriter_User
{
	protected function _getFields()
	{
		$result = parent::_getFields();
		$currencies = $this->getModelFromCache('Brivium_Credits_Model_Currency')->getAllCurrencies();
		foreach($currencies AS $currency){
			$result['xf_user'][$currency['column']] = array('type' => self::TYPE_FLOAT, 'default' => 0);
		}
		return $result;
	}
	public function save() {
		if (isset($GLOBALS['BRC_CAU_actionSave'])) {
			$GLOBALS['BRC_CAU_actionSave']->brcActionSave($this);
			unset($GLOBALS['BRC_CAU_actionSave']);
		}
		return parent::save();
	}
	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{
		$userId = $this->get('user_id');
		if (isset($GLOBALS['BRC_CPA_actionPersonalDetailsSave'])) {
			$full = $this->_checkUpdateFullProfile();
			if($full && !$this->_checkGetUpdateFull($userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId);
			}
			if(!$full && $this->_checkGetUpdateFull($userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId,array('reverted'=>true));
			}
			unset($GLOBALS['BRC_CPA_actionPersonalDetailsSave']);
		}
		
		if(!$this->getExisting('avatar_date') && $this->get('avatar_date')){
			$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('uploadAvatar',$userId);
			if($this->_checkUpdateFullProfile() && !$this->_checkGetUpdateFull($userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId);
			}
		}
		if($this->getExisting('avatar_date') && !$this->get('avatar_date')){
			$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('uploadAvatar',$userId,array('reverted'=>true));
			if(!$this->_checkUpdateFullProfile() && $this->_checkGetUpdateFull($userId)){
				$this->getModelFromCache('Brivium_Credits_Model_Credit')->updateUserCredit('updateFullProfile',$userId,array('reverted'=>true));
			}
		}
		return parent::_postSave();
	}
	protected  $_updateFull = null;
	protected  $_getUpdateFull = null;
	protected  $_uploadAvatar = null;
	
	
	
	protected function _checkGetUpdateFull($userId){
		if(!is_null($this->_getUpdateFull))return $this->_getUpdateFull;
		
		$this->_getUpdateFull = $this->getModelFromCache('Brivium_Credits_Model_Credit')->countActionOfUser('updateFullProfile',$userId);
		return $this->_getUpdateFull;
	}
	protected function _checkUpdateFullProfile()
	{
		if(!is_null($this->_updateFull))return $this->_updateFull;
		$user = $this->getMergedData();
		
		$profileFields = XenForo_Application::get("options")->BRC_fullProfileRequiredFields;
		if(!$profileFields)
		$profileFields = array(
			'homepage' => 1,
			'location' => 1,
			'occupation' => 1,
			'dob_day' => 1,
			'dob_month' => 1,
			'dob_year' => 1,
			'about' => 1,
			'avatar_date' => 1,
		);
		$count = 0;
		foreach($profileFields AS $fieldName=>$allow){
			if($this->get($fieldName) && $allow){
				if(isset($user[$fieldName]) && !empty($user[$fieldName])){
					$count ++;
				}
			}
		}
		if($count == count($profileFields)){
			$this->_updateFull = true;
		}
		$this->_updateFull = false;
		return $this->_updateFull;
	}
	
	
}
?>
