<?php
class Brivium_Credits_Installer extends Brivium_BriviumLibrary_Installer
{
	protected static $_oldCurrency = null;
	
	protected static function _installVersion_lite()
	{
		$db = self::_getDb();
		
		$db->query("DROP TABLE IF EXISTS `xf_credits_action`");
		
		self::$_oldCurrency = self::_getDb()->fetchRow('
			SELECT * FROM xf_credits_currency ORDER BY currency_id ASC LIMIT 0,1
		');
		if(!empty(self::$_oldCurrency)){
			self::$_data['xf_credits_currency'] = "
				REPLACE INTO `xf_credits_currency`
				(`currency_id`, `title`, `description`, `column`, `code`, `symbol_left`, `symbol_right`, `decimal_place`, `negative_handle`, `user_groups`, `max_time`, `earn_max`, `in_bound`, `out_bound`, `value`, `withdraw`, `withdraw_min`, `withdraw_max`, `display_order`, `active`) VALUES
				(1, '".self::$_oldCurrency['title']."', '', 'credits', '".self::$_oldCurrency['code']."', '".self::$_oldCurrency['symbol_left']."', '".self::$_oldCurrency['symbol_right']."', '".self::$_oldCurrency['decimal_place']."', 'show', '', 0, 0.0000, 1, 0, 1.0000, 1, 0.0000, 0.0000, 10, 1),
				(2, 'Point', '', 'brc_points', 'Point', '', '&nbsp;p', 2, 'show', '', 0, 0.0000, 1, 1, 21000.0000, 0, 0.0000, 0.0000, 0, 1);
			";
		}
		$db->query("DROP TABLE IF EXISTS `xf_credits_currency`");
		self::addColumn('xf_credits_transaction', 'event_id', " INT( 10 ) UNSIGNED NOT NULL DEFAULT  '0'");
		self::addColumn('xf_credits_transaction', 'currency_id', " INT( 10 ) UNSIGNED NOT NULL DEFAULT  '0'");
		self::addColumn('xf_credits_transaction', 'moderate', " tinyint(3) unsigned NOT NULL DEFAULT '0'");
		self::addColumn('xf_credits_transaction', 'content_id', " INT( 10 ) UNSIGNED NOT NULL DEFAULT  '0'");
		self::addColumn('xf_credits_transaction', 'content_type', " varchar(25) NOT NULL DEFAULT ''");
		if (self::checkIfExist('xf_credits_transaction', 'amount')) {
			$db->query(" ALTER TABLE  `xf_credits_transaction` CHANGE  `amount`  `amount` DECIMAL( 19, 4 ) NOT NULL DEFAULT  '0' ");
		}
		if (self::checkIfExist('xf_user', 'credits')) {
			$db->query(" ALTER TABLE  `xf_user` CHANGE  `credits`  `credits` DECIMAL( 19, 4 ) NOT NULL DEFAULT  '0.0000' ");
		}
		if (self::checkIfExist('xf_user', 'currency_id')) {
			$db->query("ALTER TABLE `xf_user` DROP `currency_id`");
		}
	}
	protected static function _installVersion_1010500()
	{
		self::addColumn('xf_credits_action', 'multiple_event', " TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  '0'");
	}
	protected static function _installVersion_1020000()
	{
		self::addColumn('xf_credits_action', 'allow_negative', " TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  '0'");
		self::addColumn('xf_credits_action', 'negative_handle', " VARCHAR( 30 ) NOT NULL DEFAULT  ''");
	}
	
	protected static function _installVersion_1050000()
	{
		if (self::checkIfExist('xf_credits_transaction', 'multiplier')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_transaction` CHANGE  `multiplier`  `multiplier` DECIMAL( 19, 4 ) NOT NULL DEFAULT  '0' ");
		}
	}
	
	protected static function _installVersion_1050100()
	{
		if (self::checkIfExist('xf_credits_currency', 'symbol_left')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_currency` CHANGE  `symbol_left`  `symbol_left` VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ");
		}
		if (self::checkIfExist('xf_credits_currency', 'symbol_right')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_currency` CHANGE  `symbol_right`  `symbol_right` VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ");
		}
	}
	protected static function _installVersion_1060000()
	{
		if (self::checkIfExist('xf_credits_currency', 'code')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_currency` CHANGE  `code`  `code` TEXT NOT NULL ");
		}
	}
	public static function getTables()
	{
		$tables = array();
		$tables['xf_credits_action'] = "";
		$tables['xf_credits_currency'] = "";
		$tables['xf_credits_event'] = "";
		$tables['xf_credits_transaction'] = "";
		$tables['xf_credits_paypal_log'] = "";
		return $tables;
	}
	
	public static function getAlters()
	{
		$alters = array();
		$alters['xf_user'] = array(
			'credits'	=>	"",
			'brc_points'	=>	"",
		);
		return $alters;
	}
	
	public static function init()
	{
		self::$_tables = self::getTables();
		self::$_alters = self::getAlters();
		self::$_data = self::getData();
	}
	
	public static function install($existingAddOn, $addOnData)
	{
		
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1000000){
			self::_installVersion_lite();
		}		
		self::_installVersionCurrent();
		self::_fixinstallVersionCurrent();
		self::_installData();
		
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] <= 1010500 && $existingAddOn['version_id'] >= 1000000){
			self::_installVersion_1010500();
		}
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] <= 1020000 && $existingAddOn['version_id'] >= 1000000){
			self::_installVersion_1020000();
		}
		
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1050000 && $existingAddOn['version_id'] >= 1000000){
			self::_installVersion_1050000();
		}
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1050100 && $existingAddOn['version_id'] >= 1000000){
			self::_installVersion_1050100();
		}
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1050100 && $existingAddOn['version_id'] >= 1000000){
			self::_installVersion_1050100();
		}
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1060000 && $existingAddOn['version_id'] >= 1000000){
			self::_installVersion_1060000();
		}
		self::_install($existingAddOn);
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1000000){
			self::_getDb()->query(" 
				UPDATE 
					`xf_credits_transaction` AS transaction
				SET 
					`transaction`.`event_id`=(
						SELECT `event`.`event_id` FROM `xf_credits_event` AS event WHERE `event`.`action_id` = `transaction`.`action_id` LIMIT 1
					),
					`transaction`.`currency_id`=1,
					`transaction`.`moderate`=0
			");
		}
		XenForo_Model::create('XenForo_Model_ContentType')->rebuildContentTypeCache();
		XenForo_Model::create('Brivium_Credits_Model_Action')->rebuildActionCaches();
		XenForo_Model::create('Brivium_Credits_Model_Event')->rebuildEventCache();
		XenForo_Model::create('Brivium_Credits_Model_Currency')->rebuildCurrencyCaches();
		
		return true;
	}

	protected static function _fixinstallVersionCurrent()
	{
		$db = self::_getDb();
		self::addColumn('xf_credits_action', 'multiple_event', " TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  '0'");
		self::addColumn('xf_credits_action', 'allow_negative', " TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  '0'");
		self::addColumn('xf_credits_action', 'negative_handle', " VARCHAR( 30 ) NOT NULL DEFAULT  ''");
		if (self::checkIfExist('xf_credits_transaction', 'multiplier')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_transaction` CHANGE  `multiplier`  `multiplier` DECIMAL( 19, 4 ) NOT NULL DEFAULT  '0' ");
		}
		if (self::checkIfExist('xf_credits_currency', 'symbol_left')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_currency` CHANGE  `symbol_left`  `symbol_left` VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ");
		}
		if (self::checkIfExist('xf_credits_currency', 'symbol_right')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_currency` CHANGE  `symbol_right`  `symbol_right` VARCHAR( 50 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ");
		}
		
		if (self::checkIfExist('xf_credits_currency', 'code')) {
			self::_getDb()->query(" ALTER TABLE  `xf_credits_currency` CHANGE  `code`  `code` TEXT NOT NULL ");
		}
	}
		
	protected static function _installVersionCurrent()
	{
		$db = self::_getDb();
		$db->query("
		CREATE TABLE IF NOT EXISTS `xf_credits_action` (
  `action_id` varchar(100) NOT NULL,
  `display_order` int(10) unsigned NOT NULL DEFAULT '0',
  `addon_id` varchar(25) NOT NULL,
  `template` varchar(50) NOT NULL,
  `global` tinyint(3) NOT NULL DEFAULT '0',
  `revert` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `link_format` text NOT NULL,
  `multiple_event` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `allow_negative` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `negative_handle` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`action_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");

$db->query("
CREATE TABLE IF NOT EXISTS `xf_credits_currency` (
  `currency_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `column` varchar(100) NOT NULL,
  `code` text NOT NULL,
  `symbol_left` varchar(50) NOT NULL,
  `symbol_right` varchar(50) NOT NULL,
  `decimal_place` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `negative_handle` enum('reset','hide','show') NOT NULL DEFAULT 'show',
  `user_groups` mediumblob NOT NULL,
  `max_time` int(10) unsigned NOT NULL DEFAULT '0',
  `earn_max` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `in_bound` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `out_bound` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `value` decimal(19,4) unsigned NOT NULL DEFAULT '0.0000',
  `withdraw` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `withdraw_min` decimal(19,4) unsigned NOT NULL DEFAULT '0.0000',
  `withdraw_max` decimal(19,4) unsigned NOT NULL DEFAULT '0.0000',
  `display_order` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`currency_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");

$db->query("
CREATE TABLE IF NOT EXISTS `xf_credits_event` (
  `event_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` varchar(100) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_groups` mediumblob NOT NULL,
  `forums` mediumblob NOT NULL,
  `amount` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `sub_amount` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `multiplier` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `sub_multiplier` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `moderate` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `alert` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `times` int(10) unsigned NOT NULL DEFAULT '1',
  `max_time` int(10) unsigned NOT NULL DEFAULT '0',
  `apply_max` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_min` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `extra_max` decimal(19,4) NOT NULL DEFAULT '0.0000',

  `extra_min_handle` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `target` enum('user','user_action','both') NOT NULL DEFAULT 'user',
  PRIMARY KEY (`event_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");

$db->query("
CREATE TABLE IF NOT EXISTS `xf_credits_paypal_log` (
  `payment_log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `processor` varchar(25) NOT NULL,
  `transaction_id` varchar(50) NOT NULL,
  `transaction_type` enum('payment','cancel','info','error') NOT NULL,
  `message` varchar(255) NOT NULL DEFAULT '',
  `transaction_details` mediumblob NOT NULL,
  `log_date` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`payment_log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");

$db->query("
CREATE TABLE IF NOT EXISTS `xf_credits_stats` (
  `action_id` varchar(50) NOT NULL,
  `total_earn` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `total_spend` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `start_date` int(10) unsigned NOT NULL DEFAULT '0',
  `stats_date` int(10) unsigned NOT NULL DEFAULT '0',
  `currency_id` int(10) unsigned NOT NULL,
  `stats_type` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`action_id`,`currency_id`,`stats_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
");

$db->query("
CREATE TABLE IF NOT EXISTS `xf_credits_transaction` (
  `transaction_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` varchar(100) NOT NULL,
  `event_id` int(10) unsigned NOT NULL DEFAULT '0',
  `currency_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_action_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content_type` varchar(25) NOT NULL DEFAULT '',
  `owner_id` int(10) unsigned NOT NULL DEFAULT '0',
  `multiplier` decimal(19,4) NOT NULL DEFAULT '0.0000',
  `transaction_date` int(10) NOT NULL DEFAULT '0',
  `amount` double NOT NULL DEFAULT '0',
  `negate` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `moderate` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `transaction_state` varchar(30) NOT NULL,
  `extra_data` mediumblob NOT NULL COMMENT 'Serialized. Stores any extra data relevant to the transaction',
  PRIMARY KEY (`transaction_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
");
}

protected static function _installData()
	{	
$db = self::_getDb();
$db->query("
REPLACE INTO `xf_credits_action` (`action_id`, `display_order`, `addon_id`, `template`, `global`, `revert`, `link_format`, `multiple_event`, `allow_negative`, `negative_handle`) VALUES 
('login',1,'Brivium_Credits','user',1,0,'',1,1,''),
('createNewThread',200,'Brivium_Credits','discussion_create',1,0,'',1,0,''),
('newPost',300,'Brivium_Credits','discussion_create',1,0,'',1,0,''),
('uploadAttachment',310,'Brivium_Credits','discussion',1,0,'',1,1,''),
('transfer',3,'Brivium_Credits','transfer',1,0,'',0,0,''),
('threadDeleted',210,'Brivium_Credits','discussion_delete',1,0,'',1,1,''),
('updateFullProfile',120,'Brivium_Credits','user',1,1,'',1,1,''),
('receivePostLike',320,'Brivium_Credits','discussion',1,1,'',1,1,''),
('likePost',321,'Brivium_Credits','discussion',1,1,'',1,1,''),
('postDeleted',301,'Brivium_Credits','discussion_delete',1,0,'',1,1,''),
('birthday',60,'Brivium_Credits','birthday',1,0,'',1,1,''),
('threadGetReply',240,'Brivium_Credits','discussion',1,0,'',1,0,''),
('createNewPoll',250,'Brivium_Credits','discussion',1,0,'',1,0,''),
('votePoll',251,'Brivium_Credits','discussion',1,0,'',1,0,''),
('reportPost',320,'Brivium_Credits','discussion',1,0,'',1,0,''),
('postReported',330,'Brivium_Credits','discussion',1,0,'',1,1,''),
('threadViewed',240,'Brivium_Credits','discussion',1,0,'',1,1,''),
('readThread',241,'Brivium_Credits','discussion',1,0,'',1,0,''),
('downloadAttachment',311,'Brivium_Credits','discussion',1,0,'',1,0,''),
('attachmentDownloaded',312,'Brivium_Credits','discussion',1,0,'',1,1,''),
('threadSticky',260,'Brivium_Credits','discussion',1,1,'',1,1,''),
('getFollower',141,'Brivium_Credits','user',1,1,'',1,1,''),
('updateStatus',140,'Brivium_Credits','user',1,0,'',1,0,''),
('profilePost',150,'Brivium_Credits','user',1,0,'',1,0,''),
('likeProfilePost',151,'Brivium_Credits','user',1,1,'',1,1,''),
('receiveProfilePostLike',152,'Brivium_Credits','user',1,1,'',1,1,''),
('createConversation',160,'Brivium_Credits','user',1,1,'',1,1,''),
('uploadAvatar',121,'Brivium_Credits','user',1,1,'',1,1,''),
('follow',140,'Brivium_Credits','user',1,1,'',1,1,''),
('pollGetVote',252,'Brivium_Credits','user',1,0,'',1,1,''),
('getProfilePost',150,'Brivium_Credits','user',1,0,'',1,1,''),
('interest',90,'Brivium_Credits','interest',1,0,'',0,1,''),
('importVbb',70,'Brivium_Credits','',1,0,'',0,1,''),
('registration',20,'Brivium_Credits','user',1,0,'',1,1,''),
('exchange',2,'Brivium_Credits','exchange',1,0,'',0,0,''),
('paypalPayment',10,'Brivium_Credits','PayPalPayment',1,1,'',0,0,''),
('withdraw',4,'Brivium_Credits','',1,0,'',0,0,''),
('receiveConversation',161,'Brivium_Credits','user',1,0,'',1,1,''),
('replyConversation',162,'Brivium_Credits','user',1,0,'',1,1,''),
('conversationGetReply',163,'Brivium_Credits','user',1,0,'',1,1,''),
('threadGetWatched',246,'Brivium_Credits','discussion',1,1,'',1,0,''),
('watchThread',245,'Brivium_Credits','discussion',1,1,'',1,0,''),
('dailyReward',171,'Brivium_Credits','user',1,0,'',1,1,''),
('trophyReward',170,'Brivium_Credits','user',1,0,'',1,1,'');
");

$db->query("
REPLACE INTO `xf_credits_currency` (`currency_id`, `title`, `description`, `column`, `code`, `symbol_left`, `symbol_right`, `decimal_place`, `negative_handle`, `user_groups`, `max_time`, `earn_max`, `in_bound`, `out_bound`, `value`, `withdraw`, `withdraw_min`, `withdraw_max`, `display_order`, `active`) VALUES (1,'Credit','','credits','Credit','$','',2,'show','',0,'0.0000',1,1,'1.0000',1,'0.0000','1000000.0000',10,1),
(2,'Point','','brc_points','Point','',' p',2,'show','',0,'0.0000',1,1,'21000.0000',0,'0.0000','0.0000',0,1);
");

$db->query("
REPLACE INTO `xf_credits_event` (`event_id`, `action_id`, `currency_id`, `user_groups`, `forums`, `amount`, `sub_amount`, `multiplier`, `sub_multiplier`, `active`, `moderate`, `alert`, `times`, `max_time`, `apply_max`, `extra_min`, `extra_max`, `extra_min_handle`, `target`) VALUES (1,'login',1,'a:0:{}','a:0:{}','5.0000','0.0000','0.0000','0.0000',1,0,1,1,0,0,'0.0000','0.0000',0,'user'),
(2,'exchange',1,'a:0:{}','a:0:{}','0.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(3,'withdraw',1,'a:0:{}','a:0:{}','0.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(4,'transfer',1,'a:0:{}','a:0:{}','0.5000','0.0000','0.0500','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(5,'paypalPayment',1,'a:0:{}','a:0:{}','0.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(6,'registration',1,'a:0:{}','a:0:{}','10.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(7,'birthday',1,'a:0:{}','a:0:{}','10.0000','0.0000','1.0000','0.0000',1,0,1,1,1,31536000,'13.0000','40.0000',0,'user'),
(8,'importVbb',1,'a:0:{}','a:0:{}','0.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(9,'interest',1,'a:0:{}','a:0:{}','3.0000','0.0000','0.0500','0.0000',1,0,1,0,0,0,'0.0000','1000.0000',0,'user'),
(10,'updateFullProfile',1,'a:0:{}','a:0:{}','10.0000','-10.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(11,'uploadAvatar',1,'a:0:{}','a:0:{}','3.0000','-3.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(12,'updateStatus',1,'a:0:{}','a:0:{}','2.0000','0.0000','0.0000','0.0000',1,0,1,1,0,0,'0.0000','0.0000',0,'user'),
(13,'follow',1,'a:0:{}','a:0:{}','2.0000','-2.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(14,'getFollower',1,'a:0:{}','a:0:{}','4.0000','-4.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(15,'profilePost',1,'a:0:{}','a:0:{}','2.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(16,'getProfilePost',1,'a:0:{}','a:0:{}','4.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(17,'likeProfilePost',1,'a:0:{}','a:0:{}','1.0000','-1.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(18,'receiveProfilePostLike',1,'a:0:{}','a:0:{}','2.0000','-2.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(19,'createConversation',1,'a:0:{}','a:0:{}','5.0000','-5.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(20,'createNewThread',1,'a:0:{}','a:0:{}','10.0000','0.0000','0.0100','0.0000',1,0,1,0,0,0,'20.0000','1000.0000',0,'user'),
(21,'threadDeleted',1,'a:0:{}','a:0:{}','-10.0000','0.0000','-0.0100','0.0000',1,0,1,0,0,0,'20.0000','1000.0000',0,'user'),
(22,'threadGetReply',1,'a:0:{}','a:0:{}','2.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(23,'threadViewed',1,'a:0:{}','a:0:{}','1.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(24,'readThread',1,'a:0:{}','a:0:{}','1.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(25,'createNewPoll',1,'a:0:{}','a:0:{}','5.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(26,'votePoll',1,'a:0:{}','a:0:{}','2.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(27,'pollGetVote',1,'a:0:{}','a:0:{}','3.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(28,'threadSticky',1,'a:0:{}','a:0:{}','10.0000','-10.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(29,'newPost',1,'a:0:{}','a:0:{}','5.0000','0.0000','0.0100','0.0000',1,0,1,0,0,0,'20.0000','1000.0000',0,'user'),
(30,'postDeleted',1,'a:0:{}','a:0:{}','-5.0000','0.0000','-0.0100','0.0000',1,0,1,0,0,0,'20.0000','1000.0000',0,'user'),
(31,'uploadAttachment',1,'a:0:{}','a:0:{}','4.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(32,'downloadAttachment',1,'a:0:{}','a:0:{}','2.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(33,'attachmentDownloaded',1,'a:0:{}','a:0:{}','3.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(34,'receivePostLike',1,'a:0:{}','a:0:{}','5.0000','-5.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(35,'reportPost',1,'a:0:{}','a:0:{}','5.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(36,'likePost',1,'a:0:{}','a:0:{}','2.0000','-2.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(37,'postReported',1,'a:0:{}','a:0:{}','-5.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(38,'receiveConversation',1,'a:0:{}','a:0:{}','3.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(39,'replyConversation',1,'a:0:{}','a:0:{}','2.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(40,'conversationGetReply',1,'a:0:{}','a:0:{}','1.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(111,'watchThread',1,'a:0:{}','a:0:{}','3.0000','-3.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(112,'threadGetWatched',1,'a:0:{}','a:0:{}','5.0000','-5.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(116,'trophyReward',2,'a:0:{}','a:0:{}','0.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user'),
(117,'dailyReward',2,'a:0:{}','a:0:{}','5.0000','0.0000','0.0000','0.0000',1,0,1,0,0,0,'0.0000','0.0000',0,'user');
");

$db->query("
REPLACE INTO `xf_credits_stats` (`action_id`, `total_earn`, `total_spend`, `start_date`, `stats_date`, `currency_id`, `stats_type`) VALUES ('attachmentDownloaded','0.0000','0.0000',1397777233,1397777427,1,''),
('attachmentDownloaded','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('attachmentDownloaded','0.0000','0.0000',1397777233,1397777427,2,''),
('attachmentDownloaded','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('birthday','0.0000','0.0000',1397777233,1397777427,1,''),
('birthday','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('birthday','0.0000','0.0000',1397777233,1397777427,2,''),
('birthday','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('conversationGetReply','0.0000','0.0000',1397777233,1397777427,1,''),
('conversationGetReply','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('conversationGetReply','0.0000','0.0000',1397777233,1397777427,2,''),
('conversationGetReply','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('createConversation','0.0000','0.0000',1397777233,1397777427,1,''),
('createConversation','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('createConversation','0.0000','0.0000',1397777233,1397777427,2,''),
('createConversation','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('createNewPoll','0.0000','0.0000',1397777233,1397777427,1,''),
('createNewPoll','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('createNewPoll','0.0000','0.0000',1397777233,1397777427,2,''),
('createNewPoll','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('createNewThread','0.0000','0.0000',1397777233,1397777427,1,''),
('createNewThread','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('createNewThread','0.0000','0.0000',1397777233,1397777427,2,''),
('createNewThread','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('dailyReward','0.0000','0.0000',1397777233,1397777427,1,''),
('dailyReward','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('dailyReward','0.0000','0.0000',1397777233,1397777427,2,''),
('dailyReward','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('downloadAttachment','0.0000','0.0000',1397777233,1397777427,1,''),
('downloadAttachment','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('downloadAttachment','0.0000','0.0000',1397777233,1397777427,2,''),
('downloadAttachment','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('exchange','0.0000','0.0000',1397777233,1397777427,1,''),
('exchange','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('exchange','0.0000','0.0000',1397777233,1397777427,2,''),
('exchange','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('follow','0.0000','0.0000',1397777233,1397777427,1,''),
('follow','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('follow','0.0000','0.0000',1397777233,1397777427,2,''),
('follow','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('getFollower','0.0000','0.0000',1397777233,1397777427,1,''),
('getFollower','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('getFollower','0.0000','0.0000',1397777233,1397777427,2,''),
('getFollower','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('getProfilePost','0.0000','0.0000',1397777233,1397777427,1,''),
('getProfilePost','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('getProfilePost','0.0000','0.0000',1397777233,1397777427,2,''),
('getProfilePost','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('importVbb','0.0000','0.0000',1397777233,1397777427,1,''),
('importVbb','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('importVbb','0.0000','0.0000',1397777233,1397777427,2,''),
('importVbb','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('interest','0.0000','0.0000',1397777233,1397777427,1,''),
('interest','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('interest','0.0000','0.0000',1397777233,1397777427,2,''),
('interest','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('likePost','0.0000','0.0000',1397777233,1397777427,1,''),
('likePost','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('likePost','0.0000','0.0000',1397777233,1397777427,2,''),
('likePost','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('likeProfilePost','0.0000','0.0000',1397777233,1397777427,1,''),
('likeProfilePost','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('likeProfilePost','0.0000','0.0000',1397777233,1397777427,2,''),
('likeProfilePost','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('login','0.0000','0.0000',1397777233,1397777427,1,''),
('login','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('login','0.0000','0.0000',1397777233,1397777427,2,''),
('login','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('newPost','0.0000','0.0000',1397777233,1397777427,1,''),
('newPost','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('newPost','0.0000','0.0000',1397777233,1397777427,2,''),
('newPost','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('paypalPayment','0.0000','0.0000',1397777233,1397777427,1,''),
('paypalPayment','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('paypalPayment','0.0000','0.0000',1397777233,1397777427,2,''),
('paypalPayment','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('pollGetVote','0.0000','0.0000',1397777233,1397777427,1,''),
('pollGetVote','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('pollGetVote','0.0000','0.0000',1397777233,1397777427,2,''),
('pollGetVote','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('postDeleted','0.0000','0.0000',1397777233,1397777427,1,''),
('postDeleted','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('postDeleted','0.0000','0.0000',1397777233,1397777427,2,''),
('postDeleted','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('postReported','0.0000','0.0000',1397777233,1397777427,1,''),
('postReported','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('postReported','0.0000','0.0000',1397777233,1397777427,2,''),
('postReported','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('profilePost','0.0000','0.0000',1397777233,1397777427,1,''),
('profilePost','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('profilePost','0.0000','0.0000',1397777233,1397777427,2,''),
('profilePost','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('readThread','0.0000','0.0000',1397777233,1397777427,1,''),
('readThread','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('readThread','0.0000','0.0000',1397777233,1397777427,2,''),
('readThread','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('receiveConversation','0.0000','0.0000',1397777233,1397777427,1,''),
('receiveConversation','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('receiveConversation','0.0000','0.0000',1397777233,1397777427,2,''),
('receiveConversation','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('receivePostLike','0.0000','0.0000',1397777233,1397777427,1,''),
('receivePostLike','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('receivePostLike','0.0000','0.0000',1397777233,1397777427,2,''),
('receivePostLike','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('receiveProfilePostLike','0.0000','0.0000',1397777233,1397777427,1,''),
('receiveProfilePostLike','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('receiveProfilePostLike','0.0000','0.0000',1397777233,1397777427,2,''),
('receiveProfilePostLike','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('registration','0.0000','0.0000',1397777233,1397777427,1,''),
('registration','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('registration','0.0000','0.0000',1397777233,1397777427,2,''),
('registration','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('replyConversation','0.0000','0.0000',1397777233,1397777427,1,''),
('replyConversation','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('replyConversation','0.0000','0.0000',1397777233,1397777427,2,''),
('replyConversation','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('reportPost','0.0000','0.0000',1397777233,1397777427,1,''),
('reportPost','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('reportPost','0.0000','0.0000',1397777233,1397777427,2,''),
('reportPost','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('threadDeleted','0.0000','0.0000',1397777233,1397777427,1,''),
('threadDeleted','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('threadDeleted','0.0000','0.0000',1397777233,1397777427,2,''),
('threadDeleted','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('threadGetReply','0.0000','0.0000',1397777233,1397777427,1,''),
('threadGetReply','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('threadGetReply','0.0000','0.0000',1397777233,1397777427,2,''),
('threadGetReply','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('threadGetWatched','0.0000','0.0000',1397777233,1397777427,1,''),
('threadGetWatched','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('threadGetWatched','0.0000','0.0000',1397777233,1397777427,2,''),
('threadGetWatched','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('threadSticky','0.0000','0.0000',1397777233,1397777427,1,''),
('threadSticky','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('threadSticky','0.0000','0.0000',1397777233,1397777427,2,''),
('threadSticky','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('threadViewed','0.0000','0.0000',1397777233,1397777427,1,''),
('threadViewed','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('threadViewed','0.0000','0.0000',1397777233,1397777427,2,''),
('threadViewed','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('transfer','0.0000','0.0000',1397777233,1397777427,1,''),
('transfer','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('transfer','0.0000','0.0000',1397777233,1397777427,2,''),
('transfer','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('trophyReward','0.0000','0.0000',1397777233,1397777427,1,''),
('trophyReward','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('trophyReward','0.0000','0.0000',1397777233,1397777427,2,''),
('trophyReward','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('updateFullProfile','0.0000','0.0000',1397777233,1397777427,1,''),
('updateFullProfile','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('updateFullProfile','0.0000','0.0000',1397777233,1397777427,2,''),
('updateFullProfile','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('updateStatus','0.0000','0.0000',1397777233,1397777427,1,''),
('updateStatus','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('updateStatus','0.0000','0.0000',1397777233,1397777427,2,''),
('updateStatus','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('uploadAttachment','0.0000','0.0000',1397777233,1397777427,1,''),
('uploadAttachment','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('uploadAttachment','0.0000','0.0000',1397777233,1397777427,2,''),
('uploadAttachment','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('uploadAvatar','0.0000','0.0000',1397777233,1397777427,1,''),
('uploadAvatar','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('uploadAvatar','0.0000','0.0000',1397777233,1397777427,2,''),
('uploadAvatar','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('votePoll','0.0000','0.0000',1397777233,1397777427,1,''),
('votePoll','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('votePoll','0.0000','0.0000',1397777233,1397777427,2,''),
('votePoll','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('watchThread','0.0000','0.0000',1397777233,1397777427,1,''),
('watchThread','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('watchThread','0.0000','0.0000',1397777233,1397777427,2,''),
('watchThread','0.0000','0.0000',1397775600,1397777427,2,'daily'),
('withdraw','0.0000','0.0000',1397777233,1397777427,1,''),
('withdraw','0.0000','0.0000',1397775600,1397777427,1,'daily'),
('withdraw','0.0000','0.0000',1397777233,1397777427,2,''),
('withdraw','0.0000','0.0000',1397775600,1397777427,2,'daily');
");

$db->query("
REPLACE INTO `xf_content_type` (`content_type`, `addon_id`, `fields`) VALUES ('credit','Brivium_Credits','')"
);

$db->query("
REPLACE INTO `xf_content_type_field` (`content_type`, `field_name`, `field_value`) VALUES ('credit','alert_handler_class','Brivium_Credits_AlertHandler_Credit')"
);

self::addColumn('xf_user', 'credits', " decimal(19,4) NOT NULL DEFAULT '0.0000'");
self::addColumn('xf_user', 'brc_points', " decimal(19,4) NOT NULL DEFAULT '0.0000'");
}
	
	/**
	 * So sad. Delete all the data used by this addon
	 */
	public static function uninstall()
	{
		$db = self::_getDb();
		self::init();
		self::_uninstall();
		$db->query("DELETE FROM `xf_content_type` WHERE `xf_content_type`.`content_type` = 'credit' AND `xf_content_type`.`addon_id` = 'Brivium_Credits' LIMIT 1;");
		$db->query("DELETE FROM `xf_content_type_field` WHERE `xf_content_type_field`.`content_type` = 'credit' AND `xf_content_type_field`.`content_type` = 'alert_handler_class'   AND `xf_content_type_field`.`content_type` = 'Brivium_Credits_AlertHandler_Credit'  LIMIT 1;");
        $db->query("DROP TABLE IF EXISTS `xf_credits_stats`");	
	}
}

?>