<?php

class Brivium_Credits_Listener_Listener extends Brivium_BriviumLibrary_EventListeners
{
	public static function init_dependencies(XenForo_Dependencies_Abstract $dependencies, array $data) {
		if ($dependencies instanceof XenForo_Dependencies_Admin)
		{
			XenForo_CacheRebuilder_Abstract::$builders['Credit'] = 'Brivium_Credits_CacheRebuilder_Credit';
			XenForo_CacheRebuilder_Abstract::$builders['CreditImport'] = 'Brivium_Credits_CacheRebuilder_CreditImport';
		}		
		$data = XenForo_Model::create('XenForo_Model_DataRegistry')->getMulti(array('brcCurrencies','brcEvents','brcActions'));
		$currencies = (!empty($data['brcCurrencies']) && is_array($data['brcCurrencies']) ? $data['brcCurrencies'] : XenForo_Model::create('Brivium_Credits_Model_Currency')->rebuildCurrencyCache());
		$events = (!empty($data['brcEvents']) && is_array($data['brcEvents']) ? $data['brcEvents'] : XenForo_Model::create('Brivium_Credits_Model_Event')->rebuildEventCache());
		$actions = (!empty($data['brcActions']) && is_array($data['brcActions']) ? $data['brcActions'] : XenForo_Model::create('Brivium_Credits_Model_Action')->rebuildActionCache());
		$currenciesObj = new Brivium_Credits_Currency($currencies);
		XenForo_Application::set('brcCurrencies',$currenciesObj);
		
		$actionsObj = new Brivium_Credits_Actions($actions);
		XenForo_Application::set('brcActions',$actionsObj);
		
		$eventsObj = new Brivium_Credits_Events($events);
		XenForo_Application::set('brcEvents',$eventsObj);
		
		XenForo_Template_Helper_Core::$helperCallbacks['brc_currencyformat'] = array('Brivium_Credits_Listener_Helpers', 'helperCurrencyFormat');
		XenForo_Template_Helper_Core::$helperCallbacks['brc_currencyicon'] = array('Brivium_Credits_Listener_Helpers', 'helperCurrencyIconUrl');
	}
	
	
	public static function loadClassController($class, &$extend)
	{
		switch($class){
			case 'XenForo_ControllerAdmin_User':
				$extend[] = 'Brivium_Credits_ControllerAdmin_User';
				break;
			case 'XenForo_ControllerAdmin_UserGroupPromotion':
				$extend[] = 'Brivium_Credits_ControllerAdmin_UserGroupPromotion';
				break;
			case 'XenForo_ControllerAdmin_Tools':
				$extend[] = 'Brivium_Credits_ControllerAdmin_Tools';
				break;
			case 'XenForo_ControllerPublic_Account':
				$extend[] = 'Brivium_Credits_ControllerPublic_Account';
				break;
			case 'XenForo_ControllerPublic_Login':
				$extend[] = 'Brivium_Credits_ControllerPublic_Login';
				break;
			case 'XenForo_ControllerPublic_Member':
				$extend[] = 'Brivium_Credits_ControllerPublic_Member';
				break;
			case 'XenForo_ControllerPublic_Register':
				$extend[] = 'Brivium_Credits_ControllerPublic_Register';
				break;
			case 'XenForo_ControllerPublic_Thread':
				$extend[] = 'Brivium_Credits_ControllerPublic_Thread';
				break;
		}
	}
	
	public static function loadClassDatawriter($class, &$extend)
	{
		switch($class){
			case 'XenForo_DataWriter_ConversationMaster':
				$extend[] = 'Brivium_Credits_DataWriter_ConversationMaster';
				break;
			case 'XenForo_DataWriter_ConversationMessage':
				$extend[] = 'Brivium_Credits_DataWriter_ConversationMessage';
				break;
			case 'XenForo_DataWriter_Discussion_Thread':
				$extend[] = 'Brivium_Credits_DataWriter_Discussion_Thread';
				break;
			case 'XenForo_DataWriter_DiscussionMessage_Post':
				$extend[] = 'Brivium_Credits_DataWriter_DiscussionMessage_Post';
				break;
			case 'XenForo_DataWriter_DiscussionMessage_ProfilePost':
				$extend[] = 'Brivium_Credits_DataWriter_DiscussionMessage_ProfilePost';
				break;
			case 'XenForo_DataWriter_Follower':
				$extend[] = 'Brivium_Credits_DataWriter_Follower';
				break;
			case 'XenForo_DataWriter_Poll':
				$extend[] = 'Brivium_Credits_DataWriter_Poll';
				break;
			case 'XenForo_DataWriter_Report':
				$extend[] = 'Brivium_Credits_DataWriter_Report';
				break;
			case 'XenForo_DataWriter_ThreadWatch':
				$extend[] = 'Brivium_Credits_DataWriter_ThreadWatch';
				break;
			case 'XenForo_DataWriter_User':
				$extend[] = 'Brivium_Credits_DataWriter_User';
				break;
		}
	}
	
	public static function loadClassModel($class, &$extend)
	{
		switch($class){
			case 'XenForo_Model_AddOn':
				$extend[] = 'Brivium_Credits_Model_AddOn';
				break;
			case 'XenForo_Model_Attachment':
				$extend[] = 'Brivium_Credits_Model_Attachment';
				break;
			case 'XenForo_Model_Like':
				$extend[] = 'Brivium_Credits_Model_Like';
				break;
			case 'XenForo_Model_Thread':
				$extend[] = 'Brivium_Credits_Model_Thread';
				break;
			case 'XenForo_Model_Trophy':
				$extend[] = 'Brivium_Credits_Model_Trophy';
				break;
			case 'XenForo_Model_User':
				$extend[] = 'Brivium_Credits_Model_User';
				break;
		}
	}
	
	public static function loadClassImporter($class, array &$extend)
	{
		switch($class){
			case 'XenForo_Importer_vBulletin': 
				$extend[] = 'Brivium_Credits_Importer_vBulletin';
				break;
		}
	}
	
	protected static  $_currencyFields = null;
	
	public static function criteriaUser($rule, array $data, array $user, &$returnValue) 
	{
		if(is_null(self::$_currencyFields)){
			if(is_null(self::$_currencies)){
				$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
				self::$_currencies = $currencies;
			}
			$listFields = array();
			if(self::$_currencies){
				foreach(self::$_currencies AS $currency){
					if(!empty($currency['column'])){
						$listFields[] = $currency['column'];
					}
				}
			}
			self::$_currencyFields = $listFields;
			
		}
		if(!empty(self::$_currencyFields) && in_array($rule,self::$_currencyFields)){
			if (isset($user[$rule]) && isset($data['credits']) && $user[$rule] > $data['credits'])
			{
				$returnValue = true;
			}
		}
	}
	
	
	public static function templatePostRender($templateName, &$contents, array &$containerData, XenForo_Template_Abstract $template)
	{
		if ($template instanceof XenForo_Template_Admin && $templateName == 'tools_rebuild')
		{
			$contents .= $template->create('BRC_tools_rebuild_credits', $template->getParams())->render();
			$contents .= $template->create('BRC_tools_rebuild_credit_import', $template->getParams())->render();
		}
	}
	
	protected static $_hasTemplatePerm = null;
	
	public static function templateCreate(&$templateName, array &$params, XenForo_Template_Abstract $template)
	{
		if ($template instanceof XenForo_Template_Admin)
		{
			switch ($templateName) {
				case 'user_edit':
					$template->preloadTemplate('BRC_admin_user_edit_tabs');
					$template->preloadTemplate('BRC_admin_user_edit_panes');
					break;
			}
		}else{
			if (self::$_hasTemplatePerm === null)
			{
				self::$_hasTemplatePerm = XenForo_Visitor::getInstance()->hasPermission('BR_CreditsPermission', 'useCredits');
			}

			if (!isset($params['canUseCredits']))
			{
				$params['canUseCredits'] = self::$_hasTemplatePerm;
			}
			switch ($templateName) {
				case 'member_card':
					$template->preloadTemplate('BRC_member_card_stats');
					break;
				case 'sidebar_visitor_panel':
					$template->preloadTemplate('BRC_sidebar_visitor_panel_stats');
					break;
				case 'thread_view':
					$template->preloadTemplate('BRC_message_user_info_extra');
					break;
				default:
					$template->preloadTemplate('BRC_navigation_visitor_tabs_end');
			}
		}
	}
	
	protected static  $_currencies = null;
	protected static  $canTransfer = null;
	protected static  $canPaymentPaypal = null;
	protected static  $canWithdraw = null;
	protected static  $canViewOtherTransactions = null;
	public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
		$param = array();
		
		$options = XenForo_Application::get('options');
		
		if (self::$_hasTemplatePerm === null)
		{
			self::$_hasTemplatePerm = XenForo_Visitor::getInstance()->hasPermission('BR_CreditsPermission', 'useCredits');
		}
		
		switch($hookName){
			case 'admin_user_edit_tabs': // Admin
			case 'admin_user_edit_panes': // Admin
				$newTemplate = $template->create('BRC_' . $hookName, $template->getParams());
				$contents .= $newTemplate->render();
				break;
			case 'account_alerts_extra':
				if(self::$_hasTemplatePerm){
					$newTemplate = $template->create('BRC_' . $hookName, $template->getParams());
					$contents .= $newTemplate->render();
				}
				break;
			case 'message_user_info_extra':
			case 'sidebar_visitor_panel_stats':
			case 'member_view_info_block':
			case 'member_card_stats':
			case 'navigation_visitor_tabs_end':
				if($options->get('BRC_displayOption', $hookName) && self::$_hasTemplatePerm){
					
					if(is_null(self::$_currencies)){
						$currencies = XenForo_Application::get('brcCurrencies')->getCurrencies();
						self::$_currencies = $currencies;
					}
					$currencyDisplay = $options->get('BRC_currencyDisplay');
					if(isset($currencyDisplay[0]) && ($currencyDisplay[0]==''||$currencyDisplay[0]==0)){
						$currencyDisplay = array();
					}
					$param['canTransfer'] = is_null(self::$canTransfer)?XenForo_Model::create('Brivium_Credits_Model_Credit')->checkRequireInclude('transfer'):self::$canTransfer;
					self::$canTransfer = $param['canTransfer'];
					$param['canPaymentPaypal'] = is_null(self::$canPaymentPaypal)?XenForo_Model::create('Brivium_Credits_Model_Credit')->checkRequireInclude('paypalPayment'):self::$canPaymentPaypal;
					self::$canPaymentPaypal = $param['canPaymentPaypal'];
					$param['canWithdraw'] = is_null(self::$canWithdraw)?XenForo_Model::create('Brivium_Credits_Model_Credit')->checkRequireInclude('withdraw'):self::$canWithdraw;
					self::$canWithdraw = $param['canWithdraw'];
					$param['canViewOtherTransactions'] = is_null(self::$canViewOtherTransactions)?XenForo_Model::create('Brivium_Credits_Model_Transaction')->canViewOtherTransactions():self::$canViewOtherTransactions;
					self::$canViewOtherTransactions = $param['canViewOtherTransactions'];
					$param['currencyDisplay'] = $currencyDisplay;
					$param['currencies'] = self::$_currencies;
					$newTemplate = $template->create('BRC_' . $hookName,$template->getParams());
					$newTemplate->setParams($hookParams);
					$newTemplate->setParams($param);
					$contents .= $newTemplate->render();
				}
				break;
		}
		self::_templateHook($hookName, $contents, $hookParams, $template);
    }
}
?>