<?php

class Brivium_Credits_Model_CreditStast extends XenForo_Model
{
	public function validCreditStastsRow($actionId, $currencyId)
	{
		$db = $this->_getDb();
		$actionStast = $this->_getDb()->fetchRow("
			SELECT *
			FROM xf_credits_stats
			WHERE action_id = ? AND currency_id = ?  AND stats_type = ''
		", array($actionId, $currencyId));
		$now = XenForo_Application::$time;
		if(!$actionStast){
			$db->query("
				INSERT INTO `xf_credits_stats` (`action_id`, `total_earn`, `total_spend`, `start_date`, `stats_date`, `currency_id`) VALUES
				(? , 
					IFNULL((
						SELECT SUM(amount)
						FROM xf_credits_transaction
						WHERE amount > 0 AND 
							currency_id = ? AND
							action_id = ?
					), 0),
					IFNULL((
						SELECT SUM(amount)
						FROM xf_credits_transaction
						WHERE amount < 0 AND 
							currency_id = ? AND
							action_id = ?
					), 0), 
					IFNULL((
						SELECT transaction_date
						FROM xf_credits_transaction
						WHERE currency_id = ? AND action_id = ?
						ORDER BY transaction_date ASC
						LIMIT 1
					), ?), 
					?, 
					?
				);
			",array($actionId, $currencyId, $actionId, $currencyId, $actionId, $currencyId, $actionId, $now, $now, $currencyId));
		}
		
		$dayStartTimestamps = XenForo_Locale::getDayStartTimestamps();
		$actionStastDaily = $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_credits_stats
			WHERE action_id = ? AND currency_id = ? AND stats_type = ?
		', array($actionId, $currencyId, 'daily'));
		
		if(!$actionStastDaily){
			$db->query("
				INSERT IGNORE INTO `xf_credits_stats` (`action_id`, `total_earn`, `total_spend`, `start_date`, `stats_date`, `currency_id`, `stats_type`) VALUES
				(? , 
					IFNULL((
						SELECT SUM(amount)
						FROM xf_credits_transaction
						WHERE amount > 0 AND 
							transaction_date > ? AND 
							currency_id = ? AND
							action_id = ?
					), 0),
					IFNULL((
						SELECT SUM(amount)
						FROM xf_credits_transaction
						WHERE amount < 0 AND 
							transaction_date > ? AND 
							currency_id = ? AND
							action_id = ?
					), 0),
					?, 
					?, 
					?,
					?
				);
			",array($actionId, $dayStartTimestamps['today'], $currencyId, $actionId, $dayStartTimestamps['today'], $currencyId, $actionId, $dayStartTimestamps['today'], $now, $currencyId, 'daily'));
		}
	}
	
	public function getStatisticRecord($actionId, $currencyId, $statsType='')
	{
		$db = $this->_getDb();
		$whereAction = '';
		if($actionId){
			$whereAction = " AND action_id = " . $db->quote($actionId);
		}
		return $actionStast = $db->fetchRow('
			SELECT SUM(total_earn) AS total_earn, SUM(total_spend) AS total_spend, start_date, stats_date
			FROM xf_credits_stats
			WHERE currency_id = ? AND stats_type = ? '.$whereAction.'
		', array($currencyId, $statsType));
	}
	
	public function getFirstStatisticDate($actionId, $currencyId, $statsType='')
	{
		$db = $this->_getDb();
		$whereAction = '';
		if($actionId){
			$whereAction = " AND action_id = " . $db->quote($actionId);
		}
		return $actionStast = $db->fetchOne('
			SELECT start_date
			FROM xf_credits_stats
			WHERE currency_id = ? AND stats_type = ? '.$whereAction.'
			ORDER BY  start_date ASC 
			LIMIT 1
		', array($currencyId, $statsType));
	}
	
	
	public function updateCreditStasts()
	{
		$db = $this->_getDb();
		$now = XenForo_Application::$time;
		$db->query("
			UPDATE xf_credits_stats
			SET `total_earn` = `total_earn` + IFNULL((
					SELECT SUM(amount)
					FROM xf_credits_transaction
					WHERE amount > 0 AND 
						transaction_date > xf_credits_stats.stats_date AND 
						action_id = xf_credits_stats.action_id AND
						currency_id = xf_credits_stats.currency_id
				), 0),
				`total_spend` = `total_spend` + IFNULL((
					SELECT SUM(amount)
					FROM xf_credits_transaction
					WHERE amount < 0 AND 
						transaction_date > xf_credits_stats.stats_date AND 
						action_id = xf_credits_stats.action_id AND
						currency_id = xf_credits_stats.currency_id
				), 0),
				`stats_date` = ?
			WHERE stats_type = ''
		", $now);
		$dayStartTimestamps = XenForo_Locale::getDayStartTimestamps();
		$dayTime = $dayStartTimestamps['today'];
		$db->query('
			UPDATE xf_credits_stats
			SET `total_earn` = IFNULL((
					SELECT SUM(amount)
					FROM xf_credits_transaction
					WHERE amount > 0 AND 
						transaction_date > ? AND 
						action_id = xf_credits_stats.action_id AND
						currency_id = xf_credits_stats.currency_id
				), 0),
				`total_spend` = IFNULL((
					SELECT SUM(amount)
					FROM xf_credits_transaction
					WHERE amount < 0 AND 
						transaction_date > ? AND 
						action_id = xf_credits_stats.action_id AND
						currency_id = xf_credits_stats.currency_id
				), 0),
				`stats_date` = ?
			WHERE stats_type = ?
		', array($dayTime, $dayTime, $now, 'daily'));
	}
	public function updateTransactionCreditStasts($actionId, $currencyId, $transactionId, $amount, $transactionDate)
	{
		$this->_getDb()->query("
			UPDATE xf_credits_stats
			SET `total_earn` = `total_earn` - ?,
				`total_spend` = `total_spend` - ?
			WHERE stats_date > ? AND action_id = ? AND currency_id = ?
		", array($amount>0?$amount:0, $amount<0?$amount:0, $transactionDate, $actionId, $currencyId));
	}
	
	public function canViewCreditStatistics(array $viewingUser = null)
	{
		$this->standardizeViewingUserReference($viewingUser);
		return XenForo_Permission::hasPermission($viewingUser['permissions'], 'BR_CreditsPermission', 'viewStatistic');
	}
	
}

?>