<?php

class Brivium_Credits_Model_Like extends XFCP_Brivium_Credits_Model_Like
{
	
	/**
	 * Inserts a new like for a piece of content.
	 *
	 * @param string $contentType
	 * @param integer $contentId
	 * @param integer $contentUserId User that owns/created the content
	 * @param integer|null $likeUserId User liking content; defaults to visitor
	 * @param integer|null $likeDate Timestamp of liking; defaults to now.
	 *
	 * @return array|false List of latest like users or false
	 */
	public function likeContent($contentType, $contentId, $contentUserId, $likeUserId = null, $likeDate = null)
	{
		if($contentType=='post' || $contentType=='profile_post'){
			$creditModel = $this->_getCreditModel();
			$visitor = XenForo_Visitor::getInstance();
			if ($likeUserId === null)
			{
				$likeUserId = $visitor['user_id'];
			}
			if (!$likeUserId || $contentUserId == $likeUserId)
			{
				return false;
			}
			if($contentType=='post'){
				$postModel = $this->_getPostModel();
				$post = $postModel->getPostById($contentId, array(
					'join' => XenForo_Model_Post::FETCH_THREAD | XenForo_Model_Post::FETCH_FORUM,
				));
				if(!empty($post['node_id']) && $likeUserId){
					$creditModel->setIsWaitSubmit(true);
					$dataCredit = array(
						//'user_action_id' 	=>	$contentUserId,
						'content_id' 		=>	$contentId,
						'content_type'		=>	'post',
						'node_id' 			=>	$post['node_id'],
						'extraData' 		=>	array('post_id'=>$contentId)
					);
					$creditModel->updateUserCredit('likePost',$likeUserId,$dataCredit);
					if($contentUserId){
						$creditModel->updateUserCredit('receivePostLike',$contentUserId,$dataCredit);
					}
					$creditModel->commitUpdate();
				}
				
			}else if($contentType=='profile_post'){
				$creditModel->setIsWaitSubmit(true);
				$dataCredit = array(
					'content_id' 		=>	$contentId,
					'content_type'		=>	'profile_post',
					'user_action_id' 	=>	$contentUserId,
				);
				$creditModel->updateUserCredit('likeProfilePost',$likeUserId,$dataCredit);
				if($contentUserId){
					$dataCredit = array(
						'user_action_id' 	=>	$visitor['user_id'],
					);
					$creditModel->updateUserCredit('receiveProfilePostLike',$contentUserId,$dataCredit);
				}
				$creditModel->commitUpdate();
			}
		}
		

		return parent::likeContent($contentType, $contentId, $contentUserId, $likeUserId , $likeDate);
	}

	/**
	 * Unlikes the specified like record.
	 *
	 * @param array $like
	 *
	 * @return array|false List of latest like users or false
	 */
	public function unlikeContent(array $like)
	{
		
		if(($like['content_type']=='post' || $like['content_type']=='profile_post' ) && $like['content_user_id'] != $like['like_user_id']){
			$creditModel = $this->_getCreditModel();
			$visitor = XenForo_Visitor::getInstance();
			if ($like['like_user_id'] === null)
			{
				$like['like_user_id'] = $visitor['user_id'];
			}
			if (!$like['like_user_id'])
			{
				return false;
			}
			if($like['content_type']=='post'){
				$postModel = $this->_getPostModel();
				$post = $postModel->getPostById($like['content_id'], array(
					'join' => XenForo_Model_Post::FETCH_THREAD | XenForo_Model_Post::FETCH_FORUM,
				));
				if(!empty($post['node_id']) && $like['like_user_id']){
					$creditModel->setIsWaitSubmit(true);
					$dataCredit = array(
						//'user_action_id' 	=>	$like['content_user_id'],
						'content_id' 		=>	$like['content_id'],
						'content_type'		=>	'post',
						'node_id' 			=>	$post['node_id'],
						'reverted' 			=> 	true,
						'extraData' 		=>	array('post_id'=>$like['content_id'])
					);
					$creditModel->updateUserCredit('likePost',$like['like_user_id'],$dataCredit);
					if($like['content_user_id']){
						$creditModel->updateUserCredit('receivePostLike',$like['content_user_id'],$dataCredit);
					}
					$creditModel->commitUpdate();
				}
			}else if($like['content_type']=='profile_post'){
				$creditModel->setIsWaitSubmit(true);
				$dataCredit = array(
					'content_id' 		=>	$like['content_id'],
					'content_type'		=>	'profile_post',
					'user_action_id' 	=>	$like['content_user_id'],
					'reverted' 	=> true,
				);
				$creditModel->updateUserCredit('likeProfilePost',$like['like_user_id'],$dataCredit);
				if($like['content_user_id']){
					$dataCredit = array(
						'user_action_id' 	=>	$like['like_user_id'],
						'reverted' 	=>	true,
					);
					$creditModel->updateUserCredit('receiveProfilePostLike',$like['content_user_id'],$dataCredit);
				}
				$creditModel->commitUpdate();
			}
		}

		return parent::unlikeContent($like);
	}

	
	/**
	 * Gets the post model.
	 *
	 * @return XenForo_Model_Post
	 */
	protected function _getPostModel()
	{
		return $this->getModelFromCache('XenForo_Model_Post');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
}