<?php

class Brivium_Credits_Payment_PayPal_ControllerPublic_Payment extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$currencies = $this->_getCreditHelper()->assertCurrenciesValidAndViewable('paypalPayment');
		if(!$currencies){
			return $this->responseError(new XenForo_Phrase('do_not_have_permission'));
		}
		//$currencyId = key($currencies);
		$viewParams = array(
			//'payPalUrl' => 'https://www.sandbox.paypal.com/cgi-bin/websrc',
			'payPalUrl' => 'https://www.paypal.com/cgi-bin/websrc',
			'currencies' => $currencies,
			//'currencyId' => $currencyId,
		);

		return $this->responseView(
			'Brivium_Credits_ViewPublic_Credits_Payment',
			'BRCP_paypal_form',
			$viewParams
		);
	}
	
	public function actionCreditPurchase()
	{
		$viewParams = array();

		return $this->responseView(
			'Brivium_Credits_Payment_PayPal_ViewPublic_Payment',
			'BRCP_paypal_successfull_transaction',
			$viewParams
		);
	}
	
	public function actionGetForumAmount()
	{
		$options = XenForo_Application::get('options');
		$price = $this->_input->filterSingle('price', XenForo_Input::UNUM);
		
		$currencyId = $this->_input->filterSingle('currency_id', XenForo_Input::UINT);
		if(!$currencyId)$currencyId = $this->_input->filterSingle('event_id', XenForo_Input::UINT);
		$xfToken = $this->_input->filterSingle('xfToken', XenForo_Input::STRING);
		$visitor = XenForo_Visitor::getInstance()->toArray();
		
		$currencyObj = XenForo_Application::get('brcCurrencies');
		
		list($event, $currency) = $this->_getCreditHelper()->assertEventAndCurrencyValidAndViewable('paypalPayment',$currencyId);
		
		if($options->BRCP_creditPurchaseNumber['max'] && $price > $options->BRCP_creditPurchaseNumber['max']){
			$price = $options->BRCP_creditPurchaseNumber['max'];
		}
		$moneyReceive = $price * (100 - $options->BRCP_ppTax)/100;
		
		$amount = $event['multiplier']>0?round($moneyReceive/$event['multiplier'] ,$currency['decimal_place']):$moneyReceive;
		$amount+=$event['amount'];
		
		$custom = $visitor['user_id'] .','.$currencyId.','.'paypal'.','.'token'.','.$xfToken;
		$viewParams = array(
			'amount' => $amount,
			'currency' => $currency,
			'event' => $event,
			'custom' => $custom,
		);

		return $this->responseView(
			'Brivium_Credits_Payment_PayPal_ViewPublic_Payment_GetAmount',
			'',
			$viewParams
		);
	}
	
	protected function _preDispatch($action)
	{
		$this->_assertRegistrationRequired();
		if (!$this->_getCreditModel()->canUseCredits($error))
		{
			throw $this->getErrorOrNoPermissionResponseException($error);
		}
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Credit
	 */
	protected function _getCreditModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Credit');
	}
	
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Payment_PayPal_PayPal
	 */
	protected function _getPayPalPayment()
	{
		return new Brivium_Credits_Payment_PayPal_PayPal();
	}
	
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}
	/**
	 * Gets the transaction model.
	 *
	 * @return Brivium_Credits_Model_Transaction
	 */
	protected function _getTransactionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Transaction');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Model_Action
	 */
	protected function _getActionModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Model_Action');
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_Credits_Payment_PayPal_Model_Payment
	 */
	protected function _getPaymentModel()
	{
		return $this->getModelFromCache('Brivium_Credits_Payment_PayPal_Model_Payment');
	}
	protected function _getCreditHelper()
	{
		return $this->getHelper('Brivium_Credits_ControllerHelper_Credit');
	}
}