<?php
class Brivium_Credits_Payment_PayPal_Installer
{
	public static function addColumn($table, $field, $attr)
	{
		if (!self::checkIfExist($table, $field)) {
			$db = XenForo_Application::get('db');
			return $db->query("ALTER TABLE `" . $table . "` ADD `" . $field . "` " . $attr);
		}
	}

	public static function checkIfExist($table, $field)
	{
		$db = XenForo_Application::get('db');
		if ($db->fetchRow('SHOW columns FROM `' . $table . '` WHERE Field = ?', $field)) {
			return true;
		}
		else {
			return false;
		}
	}
	public static function install($existingAddOn, $addOnData)
	{
		$db = XenForo_Application::get('db');
		$db->query("
			CREATE TABLE IF NOT EXISTS `xf_credits_paypal_log` (
			  `payment_log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
			  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
			  `processor` varchar(25) NOT NULL,
			  `transaction_id` varchar(50) NOT NULL,
			  `transaction_type` enum('payment','cancel','info','error') NOT NULL,
			  `message` varchar(255) NOT NULL DEFAULT '',
			  `transaction_details` mediumblob NOT NULL,
			  `log_date` int(10) unsigned NOT NULL DEFAULT '0',
			  PRIMARY KEY (`payment_log_id`)
			) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

		");
		return true;
	}
	
	
	/**
	 * So sad. Delete all the data used by this addon
	 */
	public static function uninstall()
	{
		$db = XenForo_Application::getDb();
		$db->query("DROP TABLE `xf_credits_paypal_log`");
		return true;
		
	}
}

?>