<?php

/**
 * Route prefix handler for actions in the admin control panel.
 *
 * @package Brivium_Credits
 */
class Brivium_Credits_Route_PrefixAdmin_Actions implements XenForo_Route_Interface
{
	/**
	 * Match a specific route for an already matched prefix.
	 *
	 * @see XenForo_Route_Interface::match()
	 */
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
		$components = explode('/', $routePath);
		$action = strtolower(array_shift($components));
		if($action!='save'){
			$action = $router->resolveActionWithStringParam($routePath, $request, 'action_id');
		}
		return $router->getRouteMatch('Brivium_Credits_ControllerAdmin_Action', $action, 'BR_credits');
	}

	/**
	 * Method to build a link to the specified page/action with the provided
	 * data and params.
	 *
	 * @see XenForo_Route_BuilderInterface
	 */
	public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
	{
		return XenForo_Link::buildBasicLinkWithStringParam($outputPrefix, $action, $extension, $data, 'action_id', 'title');
	}
}