<?php

class Brivium_HideAttachment_ControllerPublic_Attachment extends XFCP_Brivium_HideAttachment_ControllerPublic_Attachment
{
    public function actionIndex()
    {
		$attachmentId = $this->_input->filterSingle('attachment_id', XenForo_Input::UINT);
		$attachment = $this->_getAttachmentOrError($attachmentId);
		
		if(isset($attachment)){
			if($attachment['content_type'] == 'post'){
				$ftpHelper = $this->getHelper('ForumThreadPost');
				list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($attachment['content_id']);
				$hideAttachment = $this->_getHideAttachmentModel();
				if($hideAttachment->requirePermission($forum['node_id'],$post) && $hideAttachment->requirePermissionPost($post)){
					$options = XenForo_Application::get('options');
					$extensionMap = explode("\r\n",$options->BRHA_excludedFileExtensions);
					$extension = XenForo_Helper_File::getFileExtension($attachment['filename']);
					
					if (!in_array($extension, $extensionMap))
					{
						$mustReply = false;
						$mustLike = false;
						$visitorId = XenForo_Visitor::getUserId();
						if($options->BRHA_likeRequired && !$hideAttachment->checkLiked($post['post_id'],$visitorId)){
							$mustLike = true;
						}
						if($options->BRHA_replyRequired && !$hideAttachment->checkReplied($thread['thread_id'],$visitorId)){
							$mustReply = true;
						}	

						if($mustReply && $mustLike){
							return $this->responseError(new XenForo_Phrase('BRHA_mustLikeAndReply'));
						}else if($mustLike){
							return $this->responseError(new XenForo_Phrase('BRHA_mustLike'));
						}else if($mustReply){
							return $this->responseError(new XenForo_Phrase('BRHA_mustReply'));
						}
						
					}
				}
			}
		}
		return parent::actionIndex();
    }
	
	/**
	 * @return Brivium_HideAttachment_Model_HideAttachment
	 */
	protected function _getHideAttachmentModel()
	{
		return $this->getModelFromCache('Brivium_HideAttachment_Model_HideAttachment');
	}

}