<?php

class Brivium_HideAttachment_ControllerPublic_Thread extends XFCP_Brivium_HideAttachment_ControllerPublic_Thread
{
	public function actionIndex()
	{
		$reponse = parent::actionIndex();
		if(isset($reponse->params['forum'])){
			$visitorId = XenForo_Visitor::getUserId();
			$hideAttachment = $this->_getHideAttachmentModel();
			
			if(isset($reponse->params['forum']['node_id']) && isset($reponse->params['thread']) && $hideAttachment->requirePermission($reponse->params['forum']['node_id'],$reponse->params['thread'])){
				$options = XenForo_Application::get('options');
				$thread = $reponse->params['thread'];
				$mustReply = false;
				$hideThumbnail = false;
				if($options->BRHA_replyRequired && !$hideAttachment->checkReplied($thread['thread_id'],$visitorId)){
					$mustReply = true;
					$hideThumbnail = $options->BRHA_hideThumbnail;
				}
				foreach ($reponse->params['posts'] AS &$post)
				{
					$post['hideThumbnail'] = $hideThumbnail;
					if(isset($post['attachments']) && !empty($post['attachments']) && $hideAttachment->requirePermissionPost($post)){
						$exclude = false;
						$post['BRHA_mustLike'] = false;
						$post['BRHA_mustReply'] = $mustReply;
						if($options->BRHA_likeRequired && !$hideAttachment->checkLiked($post['post_id'],$visitorId)){
							$post['BRHA_mustLike'] = true;
							$post['hideThumbnail'] = $options->BRHA_hideThumbnail;
						}
					}
				}
			}
		}
		return $reponse;
	}
	public function actionCheckAttachment()
	{
		$postId = $this->_input->filterSingle('post_id', XenForo_Input::STRING);
		$postId = preg_replace("/[^0-9]/", '', $postId);
		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
		$attachments = array();
		$options = XenForo_Application::get('options');
		if($options->BRHA_hideThumbnail){
			if ($this->_getPostModel()->canLikePost($post, $thread, $forum, $errorPhraseKey))
			{
				$hideAttachment = $this->_getHideAttachmentModel();
				
				$post['BRHA_mustLike'] = false;
				$post['BRHA_mustReply'] = false;
				$visitorId = XenForo_Visitor::getUserId();
				$likeModel = $this->_getLikeModel();
				$existingLike = $this->_getLikeModel()->getContentLikeByLikeUser('post', $postId, XenForo_Visitor::getUserId());
				
				if($options->BRHA_likeRequired && $existingLike){
					$post['BRHA_mustLike'] = true;
				}
				if($options->BRHA_replyRequired && !$hideAttachment->checkReplied($thread['thread_id'],$visitorId)){
					$post['BRHA_mustReply'] = true;
				}	
				$attachments = $hideAttachment->getAttachmentsByPostId($postId);
				if(!$post['BRHA_mustLike'] && !$post['BRHA_mustReply']){
					$post['attachments'] = $attachments;
				}
			}
			$viewParams = array(
				'post_id' => $postId,
				'post' => $post,
				'attachments' => $attachments,
			);
		}else{
			$viewParams = array(
				'post_id' => 0,
				'post' => array(),
				'attachments' => array(),
			);
		}
		return $this->responseView('Brivium_HideAttachment_ViewPublic_HideAttachment', '', $viewParams);
	}
	public function actionCheckAttachmentReply()
	{
		$postIds = $this->_input->filterSingle('post_ids', XenForo_Input::ARRAY_SIMPLE);
		
		$ftpHelper = $this->getHelper('ForumThreadPost');
		
		$hideAttachment = $this->_getHideAttachmentModel();
		$likeModel = $this->_getLikeModel();
		$options = XenForo_Application::get('options');
		$visitorId = XenForo_Visitor::getUserId();
		$posts = array();
		if($options->BRHA_hideThumbnail){
			foreach($postIds AS $postId){
				$postId = preg_replace("/[^0-9]/", '', $postId);
				list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);
				$post['BRHA_mustLike'] = false;
				$post['BRHA_mustReply'] = false;
				$existingLike = $likeModel->getContentLikeByLikeUser('post', $postId, XenForo_Visitor::getUserId());
				
				if($options->BRHA_likeRequired && !$existingLike){
					$post['BRHA_mustLike'] = true;
				}
				if($options->BRHA_replyRequired && !$hideAttachment->checkReplied($thread['thread_id'],$visitorId)){
					$post['BRHA_mustReply'] = true;
				}	
				$post['attachments'] = $hideAttachment->getAttachmentsByPostId($postId);
				$posts[$post['post_id']] = $post;
			}
		}
		$viewParams = array(
			'posts' => $posts,
		);
		return $this->responseView('Brivium_HideAttachment_ViewPublic_HideAttachmentReply', '', $viewParams);
	}
	/**
	 * @return Brivium_HideAttachment_Model_HideAttachment
	 */
	protected function _getHideAttachmentModel()
	{
		return $this->getModelFromCache('Brivium_HideAttachment_Model_HideAttachment');
	}
	/**
	 * @return XenForo_Model_Like
	 */
	protected function _getLikeModel()
	{
		return $this->getModelFromCache('XenForo_Model_Like');
	}

	
}