<?php

class Brivium_HideAttachment_Model_HideAttachment extends XenForo_Model
{
	
	public function checkLiked($postId,$userId){
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_liked_content
			WHERE content_type = ? AND content_id = ? AND like_user_id = ?
		',array('post', $postId,$userId));
	}
	public function checkReplied($threadId,$userId){
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_post
			WHERE thread_id = ? AND user_id = ? AND message_state = ?
		',array($threadId,$userId,'visible'));
	}
	public function requirePermission($forumId, $post){
		$visitor = XenForo_Visitor::getInstance();
		$options = XenForo_Application::get('options');
		
		$check = true;
		$excludeGroups = $options->BRHA_excludeGroup;
		if($excludeGroups){
			$belongstogroups = $visitor['user_group_id'];

			if (!empty($visitor['secondary_group_ids']))
			{
				$belongstogroups .= ','.$visitor['secondary_group_ids'];
			}

			$groupcheck = explode(',',$belongstogroups);

			unset($belongstogroups);

			foreach ($groupcheck AS $groupId)
			{
				if (in_array($groupId, $excludeGroups))
				{
					$check = false;
					break;
				}

			}
		}
		
		$excludeForums = $options->BRHA_excludeForum;
		if($excludeForums){
			if (in_array($forumId, $excludeForums))
			{
				$check = false;
			}
		}
		return $check;
	}
	public function requirePermissionPost($post){
		$check = true;
		$visitor = XenForo_Visitor::getInstance();
		if($post['user_id'] && $post['user_id']==$visitor['user_id'])$check = false;
		return $check;
	}
	
	
	public function getAttachmentsByPostId($postId)
	{
		$attachmentModel = $this->_getAttachmentModel();
		$attachments = $attachmentModel->getAttachmentsByContentId('post', $postId);
		foreach ($attachments AS $attachment)
		{
			$attachments[$attachment['attachment_id']] = $attachmentModel->prepareAttachment($attachment);
		}

		return $attachments;
	}
	protected function _getAttachmentModel()
	{
		return $this->getModelFromCache('XenForo_Model_Attachment');
	}
	
	
}