<?php

class Brivium_HideAttachment_ViewPublic_HideAttachmentReply extends XenForo_ViewPublic_Base
{
	public function renderJson()
	{
		$output = array();
		if (!empty($this->_params['posts'])) {
			$output = $this->_params;
			$output['postIds'] = array();
			foreach($this->_params['posts'] AS $postId=>$post){
				if(!empty($post['attachments'])){
					if(!$post['BRHA_mustLike'] && !$post['BRHA_mustReply']){
						$template = $this->createTemplateObject('attached_files', array('post'=>$post));
					}else{
						$template = $this->createTemplateObject('BRHA_hide_attachment', array('post'=>$post));
					}
					$output['postIds'][$postId] = $template->render();
				}
			}
		}
		$output = XenForo_ViewRenderer_Json::jsonEncodeForOutput($output);
		return $output;
	}
	public function renderHtml()
	{
		$output = array();
		if (!empty($this->_params['posts'])) {
			$output = $this->_params;
			foreach($this->_params['posts'] AS $postId=>$post){
				if(!empty($post['attachments'])){
					if(!$post['BRHA_mustLike'] && !$post['BRHA_mustReply']){
						$template = $this->createTemplateObject('attached_files', array('post'=>$post));
					}else{
						$template = $this->createTemplateObject('BRHA_hide_attachment', array('post'=>$post));
					}
					$template->setParams($this->_params);
					$output['attachmentHtml_'.$postId] = $template->render();
				}
			}
			$output['postIds'] = array_keys($this->_params['posts']);
		}
		return $output;
	}
}