<?php
class Brivium_MultipleNodeCreate_ControllerAdmin_Category extends XFCP_Brivium_MultipleNodeCreate_ControllerAdmin_Category
{
	public function actionSave()
	{
		$nodeId = $this->_input->filterSingle('node_id', XenForo_Input::UINT);
		if($nodeId) return parent::actionSave();
		$this->_assertPostOnly();
		
		if ($this->_input->filterSingle('delete', XenForo_Input::STRING))
		{
			return $this->responseReroute('XenForo_ControllerAdmin_Category', 'deleteConfirm');
		}
		
		$titles = $this->_input->filterSingle('title', XenForo_Input::STRING, array('array' => true));
		$descriptions = $this->_input->filterSingle('description', XenForo_Input::STRING, array('array' => true));
		$displayOrders = $this->_input->filterSingle('display_order', XenForo_Input::UINT, array('array' => true));
		$response = null;
		foreach($titles AS $key=>$title){
			if($title){
				$this->_request->setParam('title', $title);
				$this->_request->setParam('description', !empty($descriptions[$key])?$descriptions[$key]:'');
				$this->_request->setParam('display_order', !empty($displayOrders[$key])?$displayOrders[$key]:0);
				$response = parent::actionSave();
			}
		}
		
		return $response?$response:$this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('nodes')
		);
	}
}