<?php

/**
 * Admin controller for handling actions on phrases.
 *
 * @package XenForo_Phrases
 */
class Brivium_MultiplePhraseCreate_ControllerAdmin_Phrase extends XFCP_Brivium_MultiplePhraseCreate_ControllerAdmin_Phrase
{
	/**
	 * Helper to get the phrase add/edit form controller response.
	 *
	 * @param array $phrase
	 * @param integer $inputLanguageId The language the phrase is being edited/created in
	 * @param integer $inputPhraseId The ID of the current phrase, or the phrase from which the value is inherited
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	protected function _getPhraseAddEditResponse(array $phrase, $inputLanguageId, $inputPhraseId = 0)
	{
		$response = parent::_getPhraseAddEditResponse($phrase, $inputLanguageId, $inputPhraseId);
		if($this->_input->filterSingle('brmpc_multiple_phrase', XenForo_Input::UINT)){
			$response->templateName = 'BRMPC_phrase_add_multiple';
		}
		return $response;
	}

	/**
	 * Form to add a phrase to the specified language. If not in debug mode,
	 * users are prevented from adding a phrase to the master language.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionAddMultiple()
	{
		$languageId = $this->_input->filterSingle('language_id', XenForo_Input::UINT);
		
		$this->_request->setParam('brmpc_multiple_phrase',true);
		
		$phrase = array(
			'phrase_id' => 0,
			'language_id' => $languageId
		);

		return $this->_getPhraseAddEditResponse($phrase, $languageId);
	}

	/**
	 * Saves a phrase. This may either be an insert or an update.
	 *
	 * @return XenForo_ControllerResponse
	 */
	public function actionSaveMultiple()
	{
		$this->_assertPostOnly();
		
		$titles = $this->_input->filterSingle('title', XenForo_Input::STRING, array('array' => true));
		$phraseTexts = $this->_input->filterSingle('phrase_text', XenForo_Input::STRING, array('array' => true, 'noTrim' => true));
		$response = null;
		foreach($titles AS $key=>$title){
			if($title){
				$this->_request->setParam('title', $title);
				$this->_request->setParam('phrase_text', !empty($phraseTexts[$key])?$phraseTexts[$key]:'');
				$response = parent::actionSave();
			}
		}
		
		return $response?$response:$this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('phrases')
		);
	}

}