
<?php

class Brivium_Pokes_AlertHandler_Poke extends XenForo_AlertHandler_Abstract
{
	/**
	 * @var XenForo_Model_Post
	 */
	protected $_postModel = null;
	/**
	 * Fetches the content required by alerts.
	 *
	 * @param array $contentIds
	 * @param XenForo_Model_Alert $model Alert model invoking this
	 * @param integer $userId User ID the alerts are for
	 * @param array $viewingUser Information about the viewing user (keys: user_id, permission_combination_id, permissions)
	 *
	 * @return array
	 */
	public function getContentByIds(array $contentIds, $model, $userId, array $viewingUser)
	{
		/* @var $eventModel Brivium_Credits_Model_Event */
		$pokeModel = $model->getModelFromCache('Brivium_Pokes_Model_Poke');
		$contents = $pokeModel->getPokeByIds($contentIds);
		return $contents ;
	}
	protected function _prepareAlertAfterAction(array $item, $content, array $viewingUser)
	{
		if (!empty($item['extra_data']))
		{
			$item['extra'] = unserialize($item['extra_data']);
		}
		unset($item['extra_data']);
		return $item;
	}
	protected function _getDefaultTemplateTitle($contentType, $action) {
		return 'BRP_alert_poke_' . $action;
	}
	
}