<?php

class Brivium_Pokes_ControllerPublic_Poke extends XenForo_ControllerPublic_Abstract
{
	public function actionIndex()
	{
		$pokeModel = $this->_getPokeModel();
		$pokes = $pokeModel->getAllPokes();
		$visitor = XenForo_Visitor::getInstance();
		
		$page = $this->_input->filterSingle('page', XenForo_Input::UINT);
		$perPage = XenForo_Application::get('options')->alertsPerPage;
		$conditions = array(
			'all_user_id'	=>	$visitor['user_id']
		);
		$pokes = $pokeModel->getPokes($conditions,array(
				'page' => $page,
				'perPage' => $perPage,
				'order' => 'poke_date',
				'join'	=>	Brivium_Pokes_Model_Poke::FETCH_FULL
			)
		);
		$pokes = $pokeModel->preparePokes($pokes);
		//prd($pokes);
		$totalPokes = $pokeModel->countPokes($conditions);
		$viewParams = array(
			'pokes' => $pokes,
			'totalPokes' => $totalPokes,
			
			'page' => $page,
			'perPage' => $perPage,
		);
		return $this->_getWrapper(
			'pokes', 'list',
			$this->responseView('Brivium_Pokes_ViewPublic_Poke_Index', 'BRP_list_pokes', $viewParams)
		);
		return ;
	}
	public function actionPoke()
	{
		$visitor = XenForo_Visitor::getInstance();
		$pokeModel = $this->_getPokeModel();
		$userModel = $this->_getUserModel();
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		
		if (!$user = $userModel->getUserById($userId))
		{
			$username = $this->_input->filterSingle('username', XenForo_Input::STRING);
			$user = $userModel->getUserByName($username);
			
		}
		if(!$user){
			return $this->responseError(new XenForo_Phrase('requested_member_not_found'), 404);
		}
		$visitor = XenForo_Visitor::getInstance();

		if (!$pokeModel->canPoke())
		{
			return $this->responseNoPermission();
		}
		
		//$noResponsePoke = $pokeModel->getNoResponsePoke($visitor['user_id'], $user['user_id']);
		$noResponsePoke = false;
		
		if ($noResponsePoke)
		{
			return $this->responseMessage(new XenForo_Phrase('BRP_x_has_not_responded_to_your_last_poke',array('username'=>$user['username'])));
		}else{
			$oldPoke = $pokeModel->getNoResponsePoke($user['user_id'], $visitor['user_id']);
			if($oldPoke){
				$oldPokeWriter = XenForo_DataWriter::create('Brivium_Pokes_DataWriter_Poke');
				$oldPokeWriter->setExistingData($oldPoke);
				$oldPokeWriter->set('response','poke_back');
				$oldPokeWriter->set('response_date',XenForo_Application::$time);
				$oldPokeWriter->save();
			}
			
			$dw = XenForo_DataWriter::create('Brivium_Pokes_DataWriter_Poke');
			$dw->set('user_id',$visitor['user_id']);
			$dw->set('poke_user_id',$user['user_id']);
			$dw->save();
			
			$pokeModel->createAlert($user['user_id'], $visitor['user_id'], $visitor['username'], $dw->get('poke_id'));
			
			$viewParams = array(
				'user' => $user,
			);
			return $this->responseView('Brivium_Pokes_ViewPublic_Poke','BRP_poke_success',$viewParams);
		}
	}
	
	/**
	 * Enforce registered-users only for all actions in this controller
	 *
	 * @see library/XenForo/XenForo_Controller#_preDispatch($action)
	 */
	protected function _preDispatch($action)
	{
		$this->_assertRegistrationRequired();
	}
	protected function _getWrapper($selectedGroup, $selectedLink, XenForo_ControllerResponse_View $subView)
	{
		return $this->getHelper('Account')->getWrapper($selectedGroup, $selectedLink, $subView);
	}
	/**
	 * Gets the action model.
	 *
	 * @return Brivium_KeyCode_Model_Code
	 */
	protected function _getPokeModel()
	{
		return $this->getModelFromCache('Brivium_Pokes_Model_Poke');
	}
	/**
	 * @return XenForo_Model_User
	 */
	protected function _getUserModel()
	{
		return $this->getModelFromCache('XenForo_Model_User');
	}

	
}