<?php

class Brivium_Pokes_DataWriter_Poke extends XenForo_DataWriter
{

	/**
	 * Title of the phrase that will be created when a call to set the
	 * existing data fails (when the data doesn't exist).
	 *
	 * @var string
	 */
	protected $_existingDataErrorPhrase = 'BRP_requested_poke_not_found';

	/**
	* Gets the fields that are defined for the table. See parent for explanation.
	*
	* @return array
	*/
	protected function _getFields()
	{
		return array(
			'xf_brivium_poke' 	=> array(
				'poke_id'       => array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'user_id'   	=> array('type' => self::TYPE_UINT, 'default' => 0),
				'poke_user_id'  => array('type' => self::TYPE_UINT, 'default' => 0),
				'poke_date'   	=> array('type' => self::TYPE_UINT, 'default' => XenForo_Application::$time),
				'response'    	=> array('type' => self::TYPE_STRING, 'maxLength' => 25,'default' => ''),
				'response_date' => array('type' => self::TYPE_UINT, 'default' => 0),
			)
		);
	}

	/**
	* Gets the actual existing data out of data that was passed in. See parent for explanation.
	*
	* @param mixed
	*
	* @return array|false
	*/
	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data, 'poke_id'))
		{
			return false;
		}
		return array('xf_brivium_poke' => $this->_getPokeModel()->getPokeById($id));
	}

	/**
	* Gets SQL condition to update the existing record.
	*
	* @return string
	*/
	protected function _getUpdateCondition($tableName)
	{
		return 'poke_id = ' . $this->_db->quote($this->getExisting('poke_id'));
	}

	/**
	 * Pre-save handling.
	 */
	protected function _preSave()
	{
	}

	/**
	 * Post-save handling.
	 */
	protected function _postSave()
	{

	}

	/**
	 * Post-delete handling.
	 */
	protected function _postDelete()
	{
	}

	/**
	 * Load action model from cache.
	 *
	 * @return Brivium_Pokes_Model_Poke
	 */
	protected function _getPokeModel()
	{
		return $this->getModelFromCache('Brivium_Pokes_Model_Poke');
	}
}