<?php
class Brivium_ProfileCover_ControllerPublic_Account extends XFCP_Brivium_ProfileCover_ControllerPublic_Account
{
	
	public function actionResizeProfileCover(){
		if (!$this->_getProfileCoverModel()->canUseProfileCover())
		{
			return $this->responseNoPermission();
		}
		$this->_assertPostOnly();
		
		$visitor = XenForo_Visitor::getInstance();
			
		$userId = $visitor['user_id'];
		
		$cropY = $this->_input->filterSingle('profile_crop_y', XenForo_Input::UNUM);
		$resizeProfileCover = $this->_getUploadImageModel()->resizeProfileCover($userId,$cropY);
		return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::SUCCESS,
				XenForo_Link::buildPublicLink('members', $visitor)
		);
	}
	
	
	public function actionUploadProfileCover(){
		
		$visitor = XenForo_Visitor::getInstance();
		
		if (!$this->_getProfileCoverModel()->canUseProfileCover())
		{
			return $this->responseNoPermission();
		}
		
		if ($this->isConfirmedPost()){
			
			$data = $this->_input->filter(array('delete' => XenForo_Input::UINT));
			$contentId = $visitor['user_id'];
			
			if($data['delete']){
				$imageType = $visitor['br_profile_image'];
				$deleteProfileCover = $this->_getUploadImageModel()->deleteProfileCover($contentId,$imageType);
			}else{
				$profileCover =  XenForo_Upload::getUploadedFile('upload_profile_cover');
				if($profileCover){
						$profileCover = $this->_getUploadImageModel()->uploadImage($profileCover,$contentId,true);
				}
			}
			
			return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_Link::buildPublicLink('members', $visitor)
			);
		}else{
		
			$maxFileSize = $visitor->hasPermission('Brivium_ProfileCover', 'maxProfileImageSize');
			$viewParams = array(
					'maxFileSize' =>false ,
			); 
		
			return $this->_getWrapper(
					'account', 'uploadProfileCover',
					$this->responseView(
							'XenForo_ViewPublic_Base',
							'BRPC_upload_profile_cover',
							$viewParams
					)
			);
		}
	}
	
	public function actionPreferencesSave()
	{
		$response =  parent::actionPreferencesSave();

		$settings = $this->_input->filter(array(
			'brpc_show_profile_cover' => XenForo_Input::UINT,
		));

		if (!$this->_saveVisitorSettings($settings, $errors))
		{
			return $this->responseError($errors);
		}

		return $response;
	}
	
	public function actionPrivacySave()
	{
		$response = parent::actionPrivacySave();

		$settings = $this->_input->filter(array(
			'brpc_allow_view_profile_cover' => XenForo_Input::STRING,
		));

		if (!$this->_saveVisitorSettings($settings, $errors))
		{
			return $this->responseError($errors);
		}

		return $response;
	}
	
	protected function _getProfileCoverModel(){
		return $this->getModelFromCache('Brivium_ProfileCover_Model_ProfileCover');
	}
	
	protected function _getUploadImageModel(){
		return $this->getModelFromCache('Brivium_ProfileCover_Model_UploadImage');
	}
}