<?php
class Brivium_ProfileCover_ControllerPublic_Member extends XFCP_Brivium_ProfileCover_ControllerPublic_Member{

	public function actionMember(){
		
		$response = parent::actionMember();
		
		$visitor = XenForo_Visitor::getInstance();
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		
		$response->params['isResizeMod'] = $this->_input->filterSingle('brpc_resize', XenForo_Input::UINT);
		if(!empty($response->params['user']['user_id'])){
			$userModel = $this->_getUserModel();
			$user = $userModel->setPermissionsFromUserId($response->params['user'],$response->params['user']['user_id']);
			if(!empty($user['global_permission_cache'])){
				$user['permissions'] = XenForo_Permission::unserializePermissions($user['global_permission_cache']);
				$response->params['user']['canUseProfileCover'] = $this->_getProfileCoverModel()->canUseProfileCover($user);
			}
		}
		if(!empty($response->params['user']['brpc_allow_view_profile_cover'])){
			$response->params['canViewProfileCover'] = $this->_getUserModel()->passesPrivacyCheck($response->params['user']['brpc_allow_view_profile_cover'], $response->params['user']);
		}
		if ($this->_getProfileCoverModel()->canDeleteProfileCover() || $visitor['user_id']==$userId){
			$response->params['canDeleteProfileCover'] = true;
		}
		return $response;
	}
	
	
	public function actionDeleteProfileCover(){
		
		$visitor = XenForo_Visitor::getInstance();
		$userId = $this->_input->filterSingle('user_id', XenForo_Input::UINT);
		
		if (!$this->_getProfileCoverModel()->canDeleteProfileCover() &&  $visitor['user_id']!=$userId)
		{
			return $this->responseNoPermission();
		}
		
		if (!$user = $this->_getUserModel()->getUserById($userId))
		{
			return $this->responseError(new XenForo_Phrase('requested_member_not_found'), 404);
		} 
		
		if ($this->isConfirmedPost())
		{
			$userId = $user['user_id'];
			$imageType = $user['br_profile_image'];
			$deleteProfileCover = $this->_getUploadImageModel()->deleteProfileCover($userId,$imageType);
			
			return $this->responseRedirect(
					XenForo_ControllerResponse_Redirect::SUCCESS,
					XenForo_Link::buildPublicLink('members', $user)
			);
		}
		else // show confirmation dialog
		{
			$viewParams = array('user' => $user);
		
			return $this->responseView('XenForo_ViewPublic_Member_Follow', 'BRPC_delete_profile_cover', $viewParams);
		}
	}
	
	protected function _getUploadImageModel(){
		return $this->getModelFromCache('Brivium_ProfileCover_Model_UploadImage');
	}
	
	protected function _getProfileCoverModel(){
		return $this->getModelFromCache('Brivium_ProfileCover_Model_ProfileCover');
	}

}