<?php

class Brivium_ProfileCover_EventListeners_Listener extends Brivium_BriviumLibrary_EventListeners{
	
	public static function initDependencies(XenForo_Dependencies_Abstract $dependencies, array $data) {
		XenForo_Template_Helper_Core::$helperCallbacks['brprofileimage'] = array('Brivium_ProfileCover_EventListeners_Helpers', 'helperProfileImage');
		XenForo_Template_Helper_Core::$helperCallbacks['brprofileimageurl'] = array('Brivium_ProfileCover_EventListeners_Helpers', 'helperProfileImageUrl');
	}
	
  public static function loadClassController($class, array &$extend)
  {
  	switch ($class){
	  	case 'XenForo_ControllerPublic_Member':
	  		$extend[] = 'Brivium_ProfileCover_ControllerPublic_Member';
	  		break;
	  	case 'XenForo_ControllerPublic_Account':
	  		$extend[] = 'Brivium_ProfileCover_ControllerPublic_Account';
	  		break;
  	}	
  }
  
  public static function loadClassDatawriter($class, array &$extend){
  	switch ($class){
  		case 'XenForo_DataWriter_User':
  			$extend[] = 'Brivium_ProfileCover_DataWriter_User';
  			break;
  	}
  }
  
  public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template){
  	switch ($hookName) {
  		case 'navigation_visitor_tab_links2':
  		case 'account_wrapper_sidebar_settings':
			if(XenForo_Model::create('Brivium_ProfileCover_Model_ProfileCover')->canUseProfileCover()){
				$newTemplate = $template->create('BRPC_' . $hookName, $template->getParams());
				$contents .= $newTemplate->render();
			}
  			break;
  		case 'account_preferences_options':
  		case 'account_privacy_personal_details':
  		case 'account_wrapper_sidebar_settings':
  			$newTemplate = $template->create('BRPC_' . $hookName, $template->getParams());
  			$contents .= $newTemplate->render();
  			break;
  	}
  	self::_templateHook($hookName, $contents, $hookParams, $template);
  }
}