<?php
class Brivium_ProfileCover_Installer extends Brivium_BriviumLibrary_Installer
{
	public static function getAlters()
	{
		$alters = array();
		$alters['xf_user'] = array(
			'br_profile_image'	=>	" varchar(30) NOT NULL DEFAULT ''",
			'br_cropy'			=>	" DECIMAL( 10, 2 ) UNSIGNED NOT NULL DEFAULT  '0'",
		);
		$alters['xf_user_option'] = array(
			'brpc_show_profile_cover'	=>	" TINYINT( 3 ) UNSIGNED NOT NULL DEFAULT  '1'",
		);
		$alters['xf_user_privacy'] = array(
			'brpc_allow_view_profile_cover'	=>	" ENUM(  'everyone',  'members',  'followed',  'none' ) NOT NULL DEFAULT  'everyone'",
		);
		return $alters;
	}
	protected static function _installVersion_1010000()
	{
		if (self::checkIfExist('xf_user', 'br_cropy')) {
			self::_getDb()->query(" ALTER TABLE  `xf_user` CHANGE  `br_cropy`  `br_cropy` DECIMAL( 10, 2 ) UNSIGNED NOT NULL DEFAULT  '0'; ");
		}
	}
	
	public static function init()
	{
		self::$_tables = self::getTables();
		self::$_alters = self::getAlters();
		self::$_data = self::getData();
	}
	

	public static function install($existingAddOn, $addOnData)
	{
		self::init();
		if(!empty($existingAddOn['version_id']) && $existingAddOn['version_id'] < 1010000){
			self::_installVersion_1010000();
		}
		self::_install($existingAddOn);
	}
	public static function uninstall()
	{
		self::init();
		self::_uninstall();
	}
}

?>