<?php
class Brivium_ProfileCover_Model_UploadImage extends XenForo_Model{

	public function uploadImage(XenForo_Upload $upload, $contentId, $permissions)
	{
		
		if (!$upload->isValid()){
			throw new XenForo_Exception($upload->getErrors(), true);
		}
		if (!$upload->isImage())
		{
			throw new XenForo_Exception(new XenForo_Phrase('uploaded_file_is_not_valid_image'), true);
		};

		$imageType = $upload->getImageInfoField('type');
		//prd($imageType);
		if (!in_array($imageType, array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG)))
		{
			throw new XenForo_Exception(new XenForo_Phrase('uploaded_file_is_not_valid_image'), true);
		}
		
		$maxFileSize = XenForo_Visitor::getInstance()->hasPermission('Brivium_ProfileCover', 'maxProfileImageSize');
		$baseTempFile = $upload->getTempFile();
		if(!$this->maxFileSize($maxFileSize*1024,$baseTempFile) and $maxFileSize!=-1){
			throw new XenForo_Exception(new XenForo_Phrase('BRPC_size_upload_x',array('maxFileSize'=>$maxFileSize)), true);
		}

		$width = $upload->getImageInfoField('width');
		$height = $upload->getImageInfoField('height');
		
		return $this->applyImage($contentId, $baseTempFile, $imageType, $width, $height, $permissions);
	}

	/**
	 * Applies the image file to the specified user.
	 *
	 * @param integer $contentId
	 * @param string $fileName
	 * @param constant|false $imageType Type of image (IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG)
	 * @param integer|false $width
	 * @param integer|false $height
	 * @param array|false $permissions
	 *
	 * @return array
	 */
	public function applyImage($contentId, $fileName, $imageType = false, $width = false, $height = false, $permissions = false)
	{
		
		
		if (!$imageType || !$width || !$height)
		{
			$imageInfo = getimagesize($fileName);
			if (!$imageInfo)
			{
				throw new XenForo_Exception('Non-image passed in to applyImage');
			}
			$width = $imageInfo[0];
			$height = $imageInfo[1];
			$imageType = $imageInfo[2];
		}
		
		if (!in_array($imageType, array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG)))
		{
			throw new XenForo_Exception('Invalid image type passed in to applyImage');
		}

		if (!XenForo_Image_Abstract::canResize($width, $height))
		{
			throw new XenForo_Exception(new XenForo_Phrase('uploaded_image_is_too_big'), true);
		}

		$outputFiles = array();
		$originalImageType = image_type_to_extension($imageType);
		
		$outputType = $imageType;
		
		$newTempFile = tempnam(XenForo_Helper_File::getTempDir(), 'xf');
		copy($fileName, $newTempFile); // no resize necessary, use the original
		$outputFiles = $newTempFile;
		
		
		$this->_writeImage($contentId, $originalImageType, $newTempFile);
		// done in 2 loops as multiple items may point to same file
		if ($newTempFile != $fileName)
		{
			@unlink($newTempFile);
		}
		
		$dwData = array(
			'br_profile_image' => $originalImageType,
			'br_cropy' => 0,
		);

		$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$dw->setExistingData($contentId);
		$dw->bulkSet($dwData);
		$dw->save();
		
		if($option = XenForo_Application::get('options')->BRPC_showInRecentActivity){
			$dwDataNewFeed = array(
					'action' => 'upload_profile_cover',
					'content_id' => $contentId,
					'content_type' => 'user',
					'extra_data' => array(),
			);
			$dw = XenForo_DataWriter::create('XenForo_DataWriter_NewsFeed');
			$dw->bulkSet($dwDataNewFeed);
			$dw->save();
		}
		return $dwData;
	}


	/**
	 * Writes out an image.
	 *
	 * @param integer $contentId
	 * @param string $imageType
	 * @param string $tempFile Temporary image file. Will be moved.
	 *
	 * @return boolean
	 */
	protected function _writeImage($contentId, $imageType, $tempFile)
	{
		$filePath = $this->getImageFilePath($contentId, $imageType);
		$directory = dirname($filePath);

		if (XenForo_Helper_File::createDirectory($directory, true) && is_writable($directory))
		{
			if (file_exists($filePath))
			{
				unlink($filePath);
			}

			$success = rename($tempFile, $filePath);
			if ($success)
			{
				XenForo_Helper_File::makeWritableByFtpUser($filePath);
			}

			return $success;
		}
		else
		{
			return false;
		}
	}
	
	/**
	 * Get the file path to an image.
	 *
	 * @param integer $contentId
	 * @param string $imageType
	 *
	 * @return string
	 */
	public function getImageFilePath($contentId, $imageType)
	{
		return sprintf('%s/brprofilecover/%s%s',
			XenForo_Helper_File::getExternalDataPath(),
			$contentId,
			$imageType
		);
	}

	/**
	 * Deletes a image.
	 *
	 * @param integer $contentId
	 * @param string $imageType
	 *
	 */
	public function deleteImage($contentId, $imageType)
	{
		$filePath = $this->getImageFilePath($contentId, $imageType);
		if (file_exists($filePath) && is_writable($filePath))
		{
			unlink($filePath);
		}
	}
	
	public function maxFileSize($maxFileSize,$baseTempFile){
		
		$fileSize = filesize($baseTempFile);
		if($fileSize>$maxFileSize){
			return false;
		}
		return true;
		
	}
	
	public function deleteProfileCover($contentId,$imageType){
		$dwData = array(
				'br_profile_image' => '',
				'br_cropy' => 0,
		);
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$dw->setExistingData($contentId);
		$dw->bulkSet($dwData);
		$dw->save();
		
		$this->deleteImage($contentId,$imageType);
	}
	
	public function resizeProfileCover($contentId,$cropY){
		$dwData = array(
				'br_cropy' => $cropY,
		);
		
		$dw = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$dw->setExistingData($contentId);
		$dw->bulkSet($dwData);
		$dw->save();
	}
	
}