<?php
class Brivium_SecretQuestion_ControllerPublic_Account extends XFCP_Brivium_SecretQuestion_ControllerPublic_Account
{
	public function actionSecurity()
	{
		$response = parent::actionSecurity();

		$auth = $this->_getUserModel()->getUserAuthenticationObjectByUserId(XenForo_Visitor::getUserId());
		$visitor = XenForo_Visitor::getInstance();

		if($auth && !empty($response->subView->params))
		{
			$response->subView->params['secretQuestion'] = $visitor['secret_question'];
		}

		return $response;
	}

	public function actionSecretSave()
	{
		$this->_assertPostOnly();

		$input = $this->_input->filter(array(
			'secret_question' => XenForo_Input::STRING,
			'secret_question_answer' => XenForo_Input::STRING
		));

		$userId = XenForo_Visitor::getUserId();

		$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
		$writer->setExistingData($userId);
		$writer->set('secret_question', $input['secret_question']);
		$writer->set('secret_question_answer', md5($input['secret_question_answer']));
		$writer->save();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('settings')
		);
	}
}