<?php

class Brivium_SecretQuestion_ControllerPublic_LostPassword extends XFCP_Brivium_SecretQuestion_ControllerPublic_LostPassword
{
	public function actionSecretQuestion()
	{
		if (XenForo_Visitor::getUserId())
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
				XenForo_Link::buildPublicLink('index')
			);
		}

		$viewParams = array();

		return $this->responseView('Brivium_SecretQuestion_ViewPublic', 'secret_question_reset', $viewParams);
	}

	public function actionVerify()
	{
		if (XenForo_Visitor::getUserId())
		{
			return $this->responseRedirect(
				XenForo_ControllerResponse_Redirect::RESOURCE_CANONICAL,
				XenForo_Link::buildPublicLink('index')
			);
		}

		$options = XenForo_Application::get('options');

		
		$question = $this->_input->filterSingle('secret_question', XenForo_Input::STRING);
		$answer = $this->_input->filterSingle('secret_question_answer', XenForo_Input::STRING);
		$username = $this->_input->filterSingle('username', XenForo_Input::STRING);

		$data = array(
			'secret_question' => $question,
			'secret_question_answer' => md5($answer),
			'username' => $username

		);		

		$users = $this->getModelFromCache('Brivium_SecretQuestion_Model_Secret')->getUserBySecretQuestion($data);
		if (!$users)
		{
			return $this->responseError(new XenForo_Phrase('requested_member_not_found'), 404);
		}
		else
		{
			$viewParams = array(
				'question' => $question,
				'count' => count($users),
				'users' => $users
			);

			if (XenForo_Application::get('options')->lostPasswordCaptcha)
			{
				$viewParams['captcha'] = XenForo_Captcha_Abstract::createDefault();
			}
		}
		
		return $this->responseView('Brivium_SecretQuestion_ViewPublic', 'secret_question_verify', $viewParams);
	}

	protected function _getUserConfirmationModel()
	{
		return $this->getModelFromCache('XenForo_Model_UserConfirmation');
	}
}