<?php

/**
 * Controller for registration-related actions.
 *
 * @package XenForo_Users
 */
class Brivium_SecretQuestion_ControllerPublic_Register extends XFCP_Brivium_SecretQuestion_ControllerPublic_Register
{
	protected function _getRegisterFormResponse(array $fields, array $errors = array())
	{
		$response = parent::_getRegisterFormResponse($fields, $errors);
		if(!empty($response->params['fields'])){
			$response->params['fields']['secret_question'] = $this->_input->filterSingle('secret_question', XenForo_Input::STRING);
			$response->params['fields']['secret_question_answer'] = $this->_input->filterSingle('secret_question_answer', XenForo_Input::STRING);
		}
		return $response;
	}
	/**
	 * Registers a new user.
	 *
	 * @return XenForo_ControllerResponse_Abstract
	 */
	public function actionRegister()
	{
		$response = parent::actionRegister();
		$userId = XenForo_Visitor::getUserId();
		if($userId){
			$input = $this->_input->filter(array(
				'secret_question' => XenForo_Input::STRING,
				'secret_question_answer' => XenForo_Input::STRING
			));
			
			$writer = XenForo_DataWriter::create('XenForo_DataWriter_User');
			$writer->setExistingData($userId);
			$writer->set('secret_question', $input['secret_question']);
			$writer->set('secret_question_answer', md5($input['secret_question_answer']));
			$writer->save();
		}
		return $response;
	}

}