<?php

class Brivium_ThreadIcon_ControllerAdmin_ThreadIcon extends XenForo_ControllerAdmin_Abstract
{

	public function actionIndex()
	{
		$icons = $this->_getThreadIconModel()->getAllIcons();

		$viewParams = array(
			'icons' => $this->_getThreadIconModel()->prepareIconsForList($icons)
		);

		return $this->responseView('Brivium_ThreadIcon_ViewAdmin', 'BRATI_icon_list', $viewParams);
	}

	public function actionAdd()
	{
		$viewParams = array(
			'icon' => array(
				'sprite_params' => $this->_getThreadIconModel()->getDefaultIconSpriteParams()
			)
		);
		return $this->responseView('Brivium_ThreadIcon_ViewAdmin', 'BRATI_icon_edit', $viewParams);
	}

	public function actionEdit()
	{
		$iconId = $this->_input->filterSingle('icon_id', XenForo_Input::UINT);
		$icon = $this->_getIconOrError($iconId);

		$viewParams = array(
			'icon' => $icon
		);
		return $this->responseView('Brivium_ThreadIcon_ViewAdmin', 'BRATI_icon_edit', $viewParams);
	}

	public function actionSave()
	{
		$this->_assertPostOnly();

		$iconId = $this->_input->filterSingle('icon_id', XenForo_Input::UINT);
		$dwInput = $this->_input->filter(array(
			'title' => XenForo_Input::STRING,
			'image_url' => XenForo_Input::STRING,
			'sprite_mode' => XenForo_Input::UINT,
			'sprite_params' => array(XenForo_Input::INT, array('array' => true))
		));

		$dw = XenForo_DataWriter::create('Brivium_ThreadIcon_DataWriter_ThreadIcon');
		if ($iconId)
		{
			$dw->setExistingData($iconId);
		}
		$dw->bulkSet($dwInput);
		$dw->save();

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildAdminLink('icons') . $this->getLastHash($iconId)
		);
	}


	public function actionValidateField()
	{
		$this->_assertPostOnly();

		return $this->_validateField('Brivium_ThreadIcon_DataWriter_ThreadIcon', array(
			'existingDataKey' => $this->_input->filterSingle('icon_id', XenForo_Input::INT)
		));
	}

	public function actionDelete()
	{
		if ($this->isConfirmedPost())
		{
			return $this->_deleteData(
				'Brivium_ThreadIcon_DataWriter_ThreadIcon', 'icon_id',
				XenForo_Link::buildAdminLink('icons')
			);
		}
		else
		{
			$iconId = $this->_input->filterSingle('icon_id', XenForo_Input::UINT);
			$icon = $this->_getIconOrError($iconId);

			$viewParams = array(
				'icon' => $icon
			);
			return $this->responseView('Brivium_ThreadIcon_ViewAdmin', 'BRATI_icon_delete', $viewParams);
		}
	}

	protected function _getIconOrError($iconId)
	{
		$iconModel = $this->_getThreadIconModel();

		$info = $iconModel->getIconById($iconId);
		if (!$info)
		{
			throw $this->responseException($this->responseError(new XenForo_Phrase('requested_thread_icon_not_found'), 404));
		}

		$icon = $iconModel->prepareIcon($info);

		if (empty($icon['sprite_params']))
		{
			$icon['sprite_params'] = $this->_getThreadIconModel()->getDefaultIconSpriteParams();
		}

		return $icon;
	}

	protected function _getThreadIconModel()
	{
		return $this->getModelFromCache('Brivium_ThreadIcon_Model_ThreadIcon');
	}
}