<?php
class Brivium_ThreadIcon_ControllerPublic_Thread extends XFCP_Brivium_ThreadIcon_ControllerPublic_Thread
{
	public function actionEdit()
	{

		$response = parent::actionEdit();

		if ($response instanceof XenForo_ControllerResponse_View)
		{
			$threadIcons = $this->_getThreadIconModel()->getAllIcons();
			$response->params += array(
				'canUseIcon' => $this->_getThreadIconModel()->canUseIcon(),
				'threadIcons' => $this->_getThreadIconModel()->prepareIconsForList($threadIcons)
			);
		}

		return $response;
	}

	public function actionEditTitle()
	{
		$response = parent::actionEditTitle();
		
		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);
		
		if ($this->isConfirmedPost())
		{
			$threadIcon = $this->_input->filterSingle('threadIcon', XenForo_Input::UINT);

			$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$dw->setExistingData($threadId);
			$dw->set('icon_id', $threadIcon);
			//$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
			$dw->save();
		}
		else
		{
			if ($response instanceof XenForo_ControllerResponse_View)
			{
				$threadIconModel = $this->_getThreadIconModel();
				$threadIcons = $threadIconModel->getAllIcons();
				$response->params += array(
					'canUseIcon' => $threadIconModel->canUseIcon(),
					'threadIcons' => $threadIconModel->prepareIconsForList($threadIcons)
				);
			}
		}
		return $response;
	}

	public function actionSave()
	{
		$response = parent::actionSave();

		$this->_assertPostOnly();
		$this->_assertRegistrationRequired();

		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($thread, $forum) = $ftpHelper->assertThreadValidAndViewable($threadId);

		$this->_assertCanEditThread($thread, $forum);

		$threadIcon = $this->_input->filterSingle('threadIcon', XenForo_Input::UINT);

		$dw = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
		$dw->setExistingData($threadId);
		$dw->set('icon_id', $threadIcon);
		//$dw->setExtraData(XenForo_DataWriter_Discussion_Thread::DATA_FORUM, $forum);
		$dw->save();

		$this->_updateModeratorLogThreadEdit($thread, $dw);

		return $response;
	}

	protected function _getThreadIconModel()
	{
		return $this->getModelFromCache('Brivium_ThreadIcon_Model_ThreadIcon');
	}
}