<?php

class Brivium_ThreadIcon_DataWriter_ThreadIcon extends XenForo_DataWriter
{
	protected function _getFields()
	{
		return array(
			'xf_thread_icon' => array(
				'icon_id'          	=> array('type' => self::TYPE_UINT,    'autoIncrement' => true),
				'title'       => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 50,
						'requiredError' => 'please_enter_valid_title'
				),
				'image_url'   => array('type' => self::TYPE_STRING, 'required' => true, 'maxLength' => 200,
						'requiredError' => 'please_enter_valid_url'
				),
				'sprite_mode' => array('type' => self::TYPE_BOOLEAN, 'default' => false),
				'sprite_params' => array('type' => self::TYPE_SERIALIZED, 'default' => ''),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$id = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('xf_thread_icon' => $this->_getThreadIconModel()->getIconById($id));
	}

	protected function _getUpdateCondition($tableName)
	{
		return 'icon_id = ' . $this->_db->quote($this->getExisting('icon_id'));
	}

	protected function _postSave()
	{
		$this->_rebuildThreadIconCache();
	}
	
	protected function _postDelete()
	{
		$this->_rebuildThreadIconCache();
	}
	
	protected function _rebuildThreadIconCache()
	{
		$this->_getThreadIconModel()->rebuildIconCache();
	}

	protected function _getThreadIconModel()
	{
		return $this->getModelFromCache('Brivium_ThreadIcon_Model_ThreadIcon');
	}
}