<?php
class Brivium_ThreadIcon_Listener extends Brivium_BriviumLibrary_EventListeners
{
	public static function initDependencies(XenForo_Dependencies_Abstract $dependencies, array $data)
	{
		XenForo_Template_Helper_Core::$helperCallbacks['brati_threadiconhtml'] = array('Brivium_ThreadIcon_Template_Helper_ThreadIcon', 'helperThreadIconHtml');
		XenForo_Template_Helper_Core::$helperCallbacks['brati_threadiconurl'] = array('Brivium_ThreadIcon_Template_Helper_ThreadIcon', 'helperThreadIconUrl');
	}
	
	public static function templateCreate($templateName, array &$params, XenForo_Template_Abstract $template) 
	{
		$template->preloadTemplate('BRATI_thread_icon');
		$template->preloadTemplate('BRATI_thread_icon_edit');
	}

    public static function templateHook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template) 
    {

    	switch ($hookName)
        {       	
            case 'thread_create_fields_extra':
                $ourTemplate = $template->create('BRATI_thread_icon_edit', $template->getParams());
                $contents .= $ourTemplate->render();
                break;
		}
		self::_templateHook($hookName, $contents, $hookParams, $template);
	}
	
	public static function loadClassController($class, &$extend)
	{
		switch($class){
			case 'XenForo_ControllerPublic_Thread':
				$extend[] = 'Brivium_ThreadIcon_ControllerPublic_Thread';
				break;
			case 'XenForo_ControllerPublic_Forum':
				$extend[] = 'Brivium_ThreadIcon_ControllerPublic_Forum';
				break;
			case 'XenForo_ControllerPublic_FindNew':
				$extend[] = 'Brivium_ThreadIcon_ControllerPublic_FindNew';
				break;
		}
	}
	
	public static function loadClassDatawriter($class, &$extend)
	{
		switch($class){
			case 'XenForo_DataWriter_Discussion_Thread':
				$extend[] = 'Brivium_ThreadIcon_DataWriter_Discussion_Thread';
				break;
		}
	}

}