<?php

class Brivium_ThreadIcon_Model_ThreadIcon extends XenForo_Model
{

	public function getIconById($iconId)
	{
		return $this->_getDb()->fetchRow('
			SELECT *
			FROM xf_thread_icon
			WHERE icon_id = ?
		', $iconId);
	}

	public function getIconForThreadId($threadId)
	{
		return $this->_getDb()->fetchRow('
			SELECT icon.*
			FROM xf_thread_icon AS icon
			INNER JOIN xf_thread AS thread ON
				(thread.icon_id = icon.icon_id)
			WHERE thread.thread_id = ?
		', $threadId);
	}

	public function getAllIcons()
	{
		return $this->fetchAllKeyed('
			SELECT *
			FROM xf_thread_icon
			ORDER BY title
		', 'icon_id');
	}

	public function getAllIconsForCache()
	{
		$icons = $this->fetchAllKeyed('
			SELECT icon_id, title, image_url,
				sprite_mode, sprite_params
			FROM xf_thread_icon
			ORDER BY icon_id
		', 'icon_id');

		$icons = $this->prepareIcons($icons);

		foreach ($icons AS &$icon)
		{
			if (!$icon['sprite_mode'] || !$icon['sprite_params'])
			{
				unset($icon['sprite_params']);
			}

			unset($icon['sprite_mode']);
		}

		return $icons;
	}

	public function rebuildIconCache()
	{
		$icons = $this->getAllIconsForCache();
		$this->_getDataRegistryModel()->set('brstiIcons', $icons);
		XenForo_Application::setSimpleCacheData('brstiIcons', $icons);
		$this->rebuildSpriteCss();

		return $icons;
	}

	public function rebuildSpriteCss()
	{
		$spriteCss = array();

		foreach ($this->getAllIcons() AS $iconId => $icon)
		{
			$icon = $this->prepareIcon($icon);

			if ($icon['sprite_mode'] && !empty($icon['sprite_params']))
			{
				$spriteCss[$iconId] = array('sprite_css' => sprintf('width: %1$dpx; height: %2$dpx; background: url(\'%3$s\') no-repeat %4$dpx %5$dpx;',
					(int)$icon['sprite_params']['w'],
					(int)$icon['sprite_params']['h'],
					htmlspecialchars($icon['image_url']),
					(int)$icon['sprite_params']['x'],
					(int)$icon['sprite_params']['y']
				));
			}
		}

		$this->_getDataRegistryModel()->set('iconSprites', $spriteCss);

		$this->getModelFromCache('XenForo_Model_Style')->updateAllStylesLastModifiedDate();

		return $spriteCss;
	}

	public function prepareIconsForList(array $icons)
	{
		$icons = $this->prepareIcons($icons);

		return $icons;
	}


	public function prepareIcons(array $icons)
	{
		return array_map(array($this, 'prepareIcon'), $icons);
	}

	public function prepareIcon(array $icon)
	{
		if (is_string($icon['sprite_params']))
		{
			$icon['sprite_params'] = unserialize($icon['sprite_params']);
		}

		return $icon;
	}

	public function getDefaultIconSpriteParams()
	{
		return array(
			'w' => 18,
			'h' => 18,
			'x' => 0,
			'y' => 0
		);
	}

	public function canUseIcon(array $user = null)
	{
		$this->standardizeViewingUserReference($user);

		return XenForo_Permission::hasPermission($user['permissions'], 'forum', 'useIcon');		
	}
	
	public function getIconsForOptionsTag($selectedIds = array(), $allIcons= null)
	{
		if ($allIcons === null)
		{
			$allIcons = $this->getAllIcons();
		}
		$allIcons = $this->prepareIcons($allIcons);
		$icons = array();
		$icons[0] = array(
			'value' => 0,
			'label' => new XenForo_Phrase('none'),
			'selected' => (!$selectedIds || !is_array($selectedIds)),
		);
		foreach ($allIcons AS $id => $icon)
		{
			if(empty($icon['sprite_mode'])){
				$image = "<img src=\"{$icon['image_url']}\" />";
			}else{
				$image = "<img src=\"styles/default/xenforo/clear.png\" 
						style=\"
						width: {$icon['sprite_params']['w']}px;
						height: {$icon['sprite_params']['h']}px;
						background: url('{$icon['image_url']}') no-repeat {$icon['sprite_params']['x']}px {$icon['sprite_params']['y']}px;\"
					/>";
			}
			$icons[$id] = array(
				'value' => $id,
				'label' => $image.'&nbsp;&nbsp;'.$icon['title'],
				'selected' => (is_array($selectedIds) && in_array($id,$selectedIds)),
			);
		}
		return $icons;
	}

	
}