<?php

/**
 * Helper methods for the social forum template functions/tags.
 */
class Brivium_ThreadIcon_Template_Helper_ThreadIcon
{
	public static function helperThreadIconHtml(array $thread, array $attributes = array(), $content = '')
	{
		$excludeForums = XenForo_Application::get('options')->ThreadIcon_exclude;
		if(empty($thread['icon_id']) || (!empty($thread['node_id']) && in_array($thread['node_id'], $excludeForums))){
			return '';
		}
		$icons = XenForo_Application::getSimpleCacheData('brstiIcons');
		if(empty($icons[$thread['icon_id']])){
			return '';
		}
		$defaultData = array(
			'sprite_params'	=> array(
				'w'	=> 0,
				'h'	=> 0,
				'x'	=> 0,
				'y'	=> 0,
			),
			'sprite_mode'	=> false,
			'image_url'	=> '',
			'title'	=> '',

		);
		$icon = $icons[$thread['icon_id']];
		$icon = array_merge($defaultData, $icon);
		
		$title = htmlspecialchars($thread['title']);
		if(empty($icon['sprite_mode'])){
			$image = "<img src=\"{$icon['image_url']}\" alt=\"{$title}\" />";
		}else{
			$image = "<img src=\"styles/default/xenforo/clear.png\" 
					style=\"
					width: {$icon['sprite_params']['w']}px;
					height: {$icon['sprite_params']['h']}px;
					background: url('{$icon['image_url']}') no-repeat {$icon['sprite_params']['x']}px {$icon['sprite_params']['y']}px;\"
					alt=\"{$title}\" 
				/>";
		}
		
		$href = XenForo_Link::buildPublicLink('threads', $thread);
		$href = ($href ? " href=\"{$href}\"" : '');

		$class = (empty($attributes['class']) ? '' : ' ' . htmlspecialchars($attributes['class']));

		$attribs = XenForo_Template_Helper_Core::getAttributes($attributes);

		if ($content !== '')
		{
			$content = " {$content}";
		}

		return "<a{$href} class=\"thread_cion {$class}\"{$attribs} data-avatarhtml=\"true\">{$image}{$content}</a>";
	}
	
	public static function helperThreadIconUrl($thread, $size, $forceType = null, $canonical = false)
	{
		if (!is_array($socialForum))
		{
			$socialForum = array();
		}

		if ($forceType)
		{
			switch ($forceType)
			{
				case 'default':
				case 'custom':
					break;

				default:
					$forceType = null;
					break;
			}
		}

		$url = self::getSocialForumAvatarUrl($socialForum, $size, $forceType);

		if ($canonical)
		{
			$url = XenForo_Link::convertUriToAbsoluteUri($url, true);
		}

		return htmlspecialchars($url);
	}
    
}